import Net from "./Net";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { Buried } from "../../../libs/tw/util/Buried";
import { MUtils } from "./MUtils";
import GameMgr from "../Mgr/GameMgr";

export namespace NetUtils {
    export function createSgin(ticketId: number, score: number, gameData: any, submitToken: string): string {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    }

    export function getOrderId() {
        return Net.cache[NetUtils.getCFG()["doJoin"]]["orderId"];
    }

    export function gameSubmit(params: {
        orderId: any,
        score: any,
        submitToken: any
    }, onSuccess: (res: any) => void, onFail?: (res: any) => any) {
        let sgin = createSgin(params.orderId, params.score, "[]", params.submitToken);
        Net.sendPost('/hdtool/recon/ngame/ngameSubmit', {
            orderId: params.orderId,
            score: params.score,
            gameData: "[]",
            sgin: sgin,
            dynamicData: JSON.stringify(`{t2:${new Date().getTime()}}`),
            rankId: window["rankId"]
        }, onSuccess, onFail);

    }

    export function ajaxElement(onSuccess: (res: any) => void, onFail?: (res: any) => void) {
        let cfg = NetUtils.getCFG();
        Net.sendPost(cfg["getElement"], {
            hdType: cfg["hdType"],
            hdToolId: cfg["hdToolId"],
            actId: cfg["actId"],
            preview: cfg["preview"]
        }, onSuccess, onFail);
    }

    function doBuried(appIdParam: string, netManager: NetManager, callback: string) {
        //初始化埋点数据
        Buried.init();
        var appId = NetUtils.getCFG()["appId"];
        var oaId = NetUtils.getCFG()["appId"];
        let data = Buried.createExposure(appId + `.110.${appIdParam}.1`, `202.${oaId}.0.0`);
        netManager[callback](data);
        console.log("exposure", data);
    }

    export function doClickBuried(appIdParam: string) {
        doBuried(appIdParam, NetManager.ins, "clickLog");
    }
    export function doShowBuried(appIdParam: string) {
        doBuried(appIdParam, NetManager.ins, "showLog");
    }

    export function encryptSeq(seq: number) {
        return Math.round(5 * seq - MUtils.random(0, 4));
    }

    export function md5(str: string) {
        return window['duiba_md5'](str);
    }
    export function getTimestamp() {
        return Date.now();
    }

    export function getCFG(): object {
        return window['CFG'];
    }

    const projectxString = "projectx/";
    export function getProjectId(): string {
        let windowUrl = window.location.href;
        let splitArr = windowUrl.split(projectxString);
        if (splitArr.length != 2) {
            return "projectId"
        }

        let start = windowUrl.indexOf(projectxString) + projectxString.length;
        let end = splitArr[1].indexOf("/");
        return windowUrl.substr(start, end);
    }

    export function visit() {
        return new Promise<any>((resolve, reject) => {
            Net.sendGet(Net.Url.visit, undefined, (res) => {
                GameMgr.instance.allPeriodEnd = res.data.allPeriodEnd;
                GameMgr.instance.leftTimes = res.data.leftTimes;
                GameMgr.instance.leftShareTimes = res.data.leftShareTimes;
                GameMgr.instance.minEnableCaptchaScore = res.data.minEnableCaptchaScore;

                resolve(res);
            }, (res) => {
                reject(res);
            })
        });
    }
}