import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./ShootPlanet/MCtrls/MPanelCtrl";
import SceneCtrl from "./ShootPlanet/MCtrls/MSceneCtrl";
import Loading from "./loading/Loading";
import ThemeAdapter from "./ThemeAdapter";
import layers from "./ShootPlanet/MViews/MLayers";
import TopLayerCtrl from './ShootPlanet/MCtrls/MTopLayerCtrl';
import { getResPath, arrayRemove, isWeiXin } from "./ShootPlanet/Global/GUtils";
import { customClassPrototype } from "./ShootPlanet/MComponents/Custom";
import { Decorator } from "./ShootPlanet/Decorator/Decorator";
import ToastPanel from "./ShootPlanet/MComponents/MToastPanel";
import MProgressBar from "./ShootPlanet/MUI/MProgressBar";
import MButton from "./ShootPlanet/MUI/MButton";
import Net from "./ShootPlanet/Global/Net";
import MainScene from "./ShootPlanet/Scene/MainScene";
import StartScene from "./ShootPlanet/Scene/StartScene";
import MTimer from "./ShootPlanet/MComponents/MTimer";
import MTweenMgr from "./ShootPlanet/MComponents/MTween";
import PhycicsSystem from "./ShootPlanet/Game/PhycicsSystem";
import Ball from "./ShootPlanet/Global/Ball";
import { NetUtils } from "./ShootPlanet/Global/NetUtils";
import MLabel from "./ShootPlanet/MUI/MLabel";
import { MConfigs } from "./ShootPlanet/Global/MConfigs";
import SoundMgr from "./ShootPlanet/Mgr/SoundMgr";
import DropBlinkMgr from "./ShootPlanet/Game/DropBlinkMgr";
import GameMgr from "./ShootPlanet/Mgr/GameMgr";
import { MConst } from "./ShootPlanet/Global/MConst";
import MBuried from "./ShootPlanet/Global/MBuried";

class Main extends eui.UILayer {
    constructor() {
        super();
        customClassPrototype();
    }

    protected createChildren() {
        super.createChildren();

        MTimer.init();
        MTweenMgr.instance.init();
        PhycicsSystem.init();
        Net.urlReplace();
        MConfigs.updateConfig();
        DropBlinkMgr.init();

        let url = window.location.href;
        let projectId = url.split("projectId=")[1].split("&")[0];
        MBuried.init(MConfigs.appId, projectId);

        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        TopLayerCtrl.instance.init(layers.topLayer);
        ToastPanel.parent = layers.toastLayer;

        //设置屏幕适配方式
        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.runGame().catch(e => {
            console.log(e);
        });
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
    }

    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
            await RES.loadGroup("loading");
            Loading.instace.show();
            await RES.loadGroup("toast_panel");
            Loading.instace.hide();
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    private textfield: egret.TextField;
    /**
     * 创建场景界面
     * Create scene interface
     */
    protected async createGameScene() {
        console.log("CFG", NetUtils.getCFG());
        SoundMgr.instance.setMusic("bgm_mp3");
        SceneCtrl.instance.change(StartScene);
    }
}

window["Main"] = Main;
window["MProgressBar"] = MProgressBar;
window["MButton"] = MButton;
window["MLabel"] = MLabel;