"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Scene_1 = require("../views/Scene");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var GDispatcher_1 = require("../../libs/tc/util/GDispatcher");
var ABNetManager_1 = require("../../libs/tc/manager/ABNetManager");
var FriendItem_1 = require("./FriendItem");
var NetName_1 = require("../../libs/tw/enum/NetName");
var DogItem_1 = require("./DogItem");
var DataConversion_1 = require("./DataConversion");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var topLayerCtrl_1 = require("../ctrls/topLayerCtrl");
var MainScene = (function (_super) {
    __extends(MainScene, _super);
    function MainScene(data) {
        var _this = _super.call(this, data) || this;
        /* private dogLvLists=[
    
        ]
     */
        _this.dogLvLists = [
            "小奶狗",
            "小白狗",
            "小黑狗",
            "小狼狗",
            "金毛",
            "柯基",
            "柴犬",
            "博美",
            "泰迪",
            "巴哥犬",
            "比熊",
            "雪纳瑞",
            "秋田犬",
            "萨摩耶",
            "贵宾犬",
            "边境牧羊犬",
            "拉布拉多",
            "哈士奇",
            "吉娃娃",
            "法国斗牛犬",
            "牛头梗",
            "蝴蝶犬",
            "杜宾",
            "松狮",
            "茶杯犬",
            "苏格兰牧羊犬",
            "英国玩具犬",
            "迦南犬",
            "阿拉斯加雪橇犬",
            "阿富汗猎犬",
        ];
        _this.teams = [];
        _this.doglists = [];
        _this.dogPositions = [];
        _this.Events = [];
        _this.isHover = false;
        _this.locationData = [];
        _this.doSummonCount = 0;
        _this.firstTipsCoun = 0;
        //组队数据
        _this.teamData = [];
        //最大等级
        _this.maxLevel = 0;
        //生产速率
        _this.yieldRate = 0;
        //粮食库存
        _this.foodStocks = 0;
        _this.winStates = [];
        _this.wins = [];
        if (data) {
        }
        _this.percentHeight = 100;
        return _this;
    }
    Object.defineProperty(MainScene.prototype, "skinKey", {
        get: function () { return 'MainScene'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MainScene.prototype, "groupName", {
        get: function () { return 'main_scene'; },
        enumerable: true,
        configurable: true
    });
    MainScene.prototype.initEvents = function () {
        GDispatcher_1.GDispatcher.addEvent(ABNetManager_1.ABNetManager.ERROR, this.onError, this);
        this.addDogBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addDogBtn, this);
        this.ydDogAddBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ydDogAddBtn, this);
        this.mapBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_mapBtn, this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        this.shopBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shopBtn, this);
        this.teamBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_teamBtn, this);
        GDispatcher_1.GDispatcher.addEvent("doSummon", this.Events["doSummon"] = this.doSummon1, this);
        GDispatcher_1.GDispatcher.addEvent("doRecycle", this.Events["doRecycle"] = this.doRecycle, this);
        GDispatcher_1.GDispatcher.addEvent("cancelRecycle", this.Events["cancelRecycle"] = this.cancelRecycle, this);
        GDispatcher_1.GDispatcher.addEvent("mapBtnAn", this.Events["mapBtnSAn"] = this.mapBtnSAn, this);
        GDispatcher_1.GDispatcher.addEvent("mapBtnAn", this.Events["mapBtnSAn"] = this.mapBtnSAn, this);
        for (var i = 0; i < 6; i++) {
            this.teams[i] = new FriendItem_1.default();
            this.teams[i].x = 0;
            this.teams[i].y = 0;
            this["team_" + i].addChild(this.teams[i]);
        }
        for (var i = 0; i < 12; i++) {
            this.doglists[i] = new DogItem_1.default();
            this.doglists[i].x = -8;
            this.doglists[i].y = -60;
            this["doglist_" + i].addChild(this.doglists[i]);
        }
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.touchBegin, this);
        this.addEventListener(egret.TouchEvent.TOUCH_END, this.touchEnd, this);
        this.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.touchMove, this);
        this.Events["updateIncome"] = setInterval(this.updateIncome.bind(this), 3000);
    };
    MainScene.prototype.removeEvents = function () {
        GDispatcher_1.GDispatcher.removeEvent(ABNetManager_1.ABNetManager.ERROR, this.onError, this);
        this.addDogBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addDogBtn, this);
        this.ydDogAddBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ydDogAddBtn, this);
        this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.mapBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_mapBtn, this);
        this.shopBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shopBtn, this);
        this.teamBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_teamBtn, this);
        GDispatcher_1.GDispatcher.removeEvent("doSummon", this.Events["doSummon"], this);
        GDispatcher_1.GDispatcher.removeEvent("doRecycle", this.Events["doRecycle"], this);
        GDispatcher_1.GDispatcher.removeEvent("cancelRecycle", this.Events["cancelRecycle"], this);
        GDispatcher_1.GDispatcher.removeEvent("mapBtnAn", this.Events["mapBtnSAn"], this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.touchBegin, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_END, this.touchEnd, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.touchMove, this);
        clearInterval(this.Events["updateIncome"]);
    };
    MainScene.prototype.onTap_teamBtn = function () {
        var _this = this;
        console.log("ce");
        this.enabled = false;
        NetManager_1.NetManager.ins.getTeamInfo(function (succuss) {
            _this.enabled = true;
            if (!succuss) {
                return;
            }
            sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.TEAM_SCENE);
        }, window["CFG"].activityId);
    };
    MainScene.prototype.mapBtnSAn = function () {
        this.enabled = true;
        this["mapBtnS"].play(0);
    };
    MainScene.prototype.onTap_ydDogAddBtn = function () {
        this.addDogBtn.dispatchEventWith(egret.TouchEvent.TOUCH_TAP);
        this.yd_dogAdd.visible = false;
        egret.Tween.get(this.addDogBtn).to({ scaleX: 0.9, scaleY: 0.9 }, 100).to({ scaleX: 1, scaleY: 1 }, 100).call(function () { });
    };
    MainScene.prototype.touchBegin = function (e) {
        if (!this.isCanMove()) {
            return false;
        }
        this.targetDog = null;
        for (var i = 0; i < 12; i++) {
            var target = this["doglist_" + i];
            if (target.canMove) {
                if (e.stageX >= target.x && e.stageX <= (target.x + target.width) &&
                    e.stageY >= target.y && e.stageY <= (target.y + target.height)) {
                    this.from = i;
                    this.targetCatch = {
                        x: target.x,
                        y: target.y,
                    };
                    this.targetDog = target;
                    this.catchIndex = this.getChildIndex(this.targetDog);
                    this.setChildIndex(this.targetDog, 40);
                }
            }
        }
    };
    MainScene.prototype.preLoadRes = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, mcJson, mcImg, mcImg, _b, _c, _d, _e, mcFactory;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        //加载背景并设置背景图片
                        _a = this;
                        return [4 /*yield*/, RES.getResAsync('main_Bg_jpg')];
                    case 1:
                        //加载背景并设置背景图片
                        _a.bgtexture = _f.sent();
                        return [4 /*yield*/, RES.getResAsync('main_star_an_json')];
                    case 2:
                        mcJson = _f.sent();
                        return [4 /*yield*/, RES.getResAsync('main_star_an_png')];
                    case 3:
                        mcImg = _f.sent();
                        return [4 /*yield*/, RES.getResAsync('main_star_an_png')];
                    case 4:
                        mcImg = _f.sent();
                        _b = this;
                        return [4 /*yield*/, RES.getResAsync("music_add_dog_mp3")];
                    case 5:
                        _b.music_add_dog = _f.sent();
                        _c = this;
                        return [4 /*yield*/, RES.getResAsync("music_recycle_mp3")];
                    case 6:
                        _c.music_recycle = _f.sent();
                        _d = this;
                        return [4 /*yield*/, RES.getResAsync("music_food_mp3")];
                    case 7:
                        _d.music_food = _f.sent();
                        _e = this;
                        return [4 /*yield*/, RES.getResAsync("music_newdog_mp3")];
                    case 8:
                        _e.music_newdog = _f.sent();
                        mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);
                        this.starAn = new egret.MovieClip(mcFactory.generateMovieClipData());
                        return [2 /*return*/, new Promise(function (resolve, reject) {
                                resolve();
                            })];
                }
            });
        });
    };
    MainScene.prototype.touchMove = function (e) {
        if (!this.isCanMove()) {
            return false;
        }
        if (this.targetDog) {
            this.yd_dogMerge.visible = false;
            this.targetDog.x = e.stageX - (80);
            this.targetDog.y = e.stageY - (60);
            var _x = this.bottomGroup.x + this.recycleBtn.x - this.bottomGroup.width / 2;
            var _y = this.bottomGroup.y + this.recycleBtn.y - this.bottomGroup.height / 2;
            if (e.stageX >= _x &&
                e.stageX <= _x + this.bottomGroup.width &&
                e.stageY >= _y &&
                e.stageY <= _y + this.bottomGroup.height) {
                console.log("进入回收区域");
                if (!this.isHover) {
                    this.isHover = true;
                    this["recycleHover"].play(0);
                }
            }
            else {
                if (this.isHover) {
                    this.isHover = false;
                    this["recycleOut"].play(0);
                }
            }
        }
    };
    //执行销毁
    MainScene.prototype.doRecycle = function (location) {
        var _this = this;
        this.music_recycle.play(0, 1);
        NetManager_1.NetManager.ins.getRecycle(function (succuss) {
            if (!succuss) {
                _this.enabled = true;
                _this.updateDogList(false);
                return;
            }
            _this.recycleIncome = DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_RECYCLE).data.recycleIncome;
            _this.recycleText.text = DataConversion_1.default.doConversion(_this.recycleIncome);
            _this["recycleTextAn"].play(0);
            _this.resetData(DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_RECYCLE).data);
            _this.enabled = true;
            _this.updateIndex();
        }, location, window["CFG"].activityId);
    };
    MainScene.prototype.cancelRecycle = function () {
        this.updateDogList(false);
    };
    MainScene.prototype.touchEnd = function (e) {
        var _this = this;
        if (!this.isCanMove()) {
            return false;
        }
        if (this.isHover) {
            this.isHover = false;
            this["recycleOut"].play(0);
            console.log("执行回收");
            if (this.homeData.dogs.length <= 5) {
                this.showToast("场上狗狗低于6只，不能再回收了");
                //this.updateDogList(false)
                egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(function () {
                    _this.enabled = true;
                });
            }
            else {
                this.openRecyclePanel(this.from);
            }
            this.addChild(this.bottomGroup);
            this.enabled = true;
            this.targetDog = null;
            return false;
        }
        for (var i = 0; i < this.dogPositions.length; i++) {
            var target = this.dogPositions[i];
            if (e.stageX >= target.x && e.stageX <= (target.x + target.width) &&
                e.stageY >= target.y && e.stageY <= (target.y + target.height)) {
                if (this.targetDog) {
                    this.setChildIndex(this.targetDog, this.catchIndex);
                    this.enabled = false;
                    this.to = i;
                    if (this.locationData.indexOf(this.to) == -1) {
                        egret.Tween.get(this.targetDog).to({ x: this.dogPositions[i].x, y: this.dogPositions[i].y }, 500).call(function () {
                            //移动位置
                            _this.doLocation();
                        });
                        this.targetDog = null;
                        this.addChild(this.bottomGroup);
                    }
                    else {
                        var lvFrom;
                        var lvTo;
                        for (var j = 0; j < this.dogData.length; j++) {
                            if (this.from == this.dogData[j].location) {
                                lvFrom = this.dogData[j].level;
                            }
                            if (this.to == this.dogData[j].location) {
                                lvTo = this.dogData[j].level;
                            }
                        }
                        if (lvFrom == lvTo && this.from != this.to) {
                            if (lvFrom < 30 || lvTo < 30) {
                                egret.Tween.get(this.targetDog).to({ x: this.dogPositions[i].x, y: this.dogPositions[i].y }, 100).call(function () {
                                    //合并
                                    console.log(lvFrom);
                                    console.log(lvTo);
                                    var x = _this["doglist_" + _this.from].x;
                                    egret.Tween.get(_this["doglist_" + _this.to]).to({ x: x - 50 }, 150).to({ x: x }, 150).call(function () {
                                    });
                                    egret.Tween.get(_this["doglist_" + _this.from]).to({ x: x + 50 }, 150).to({ x: x }, 150).call(function () {
                                        _this.doMerge(lvFrom);
                                    });
                                });
                            }
                            else {
                                this.showToast("已达到最高等级！");
                                egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(function () {
                                    _this.enabled = true;
                                });
                            }
                            this.targetDog = null;
                            this.addChild(this.bottomGroup);
                        }
                        else {
                            egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(function () {
                                _this.enabled = true;
                            });
                            this.targetDog = null;
                            this.addChild(this.bottomGroup);
                        }
                    }
                }
                return;
            }
        }
        if (this.targetDog) {
            this.enabled = false;
            egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(function () {
                _this.enabled = true;
            });
            this.targetDog = null;
            this.addChild(this.bottomGroup);
        }
    };
    MainScene.prototype.showToast = function (val) {
        //console.log(val)
        topLayerCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.TOAST_PANEL, { msg: val });
    };
    //更新收入+增加积分
    MainScene.prototype.updateIncome = function () {
        this.dogRate();
        this.foodStocks += (this.yieldRate * 3);
        this.updateAllTextFromLocalCount();
        this["foodUpdate"].play(0);
    };
    MainScene.prototype.onTap_addDogBtn = function () {
        this.music_add_dog.play(0, 1);
        this.enabled = false;
        this.doSummonCount = 0;
        if (this.homeData.dogs.length >= 12) {
            this.enabled = true;
            this.showToast("空间不足，请合成或拖到右下角回收");
            return;
        }
        this.doSummon(this.homeData.summonLevel);
    };
    MainScene.prototype.doSummon1 = function (level) {
        this.doSummonCount = 0;
        this.doSummon(level);
    };
    //召唤狗狗
    MainScene.prototype.doSummon = function (level) {
        var _this = this;
        if (this.homeData.dogs.length >= 12) {
            this.enabled = true;
            this.showToast("空间不足，请合成或拖到右下角回收");
            return;
        }
        //if (this.homeData.summonConsume <= this.foodStocks) {
        for (var i = 0; i < 12; i++) {
            if (this.locationData.indexOf(i) == -1) {
                this.addLocation = i;
                break;
            }
        }
        console.log(this.addLocation);
        this.enabled = false;
        NetManager_1.NetManager.ins.getSummon(function (succuss) {
            if (!succuss) {
                _this.doSummonCount++;
                if (_this.doSummonCount == 1) {
                    _this.doSummonBeforeHome(level);
                }
                if (_this.doSummonCount >= 2) {
                    _this.enabled = true;
                }
                return;
            }
            _this.doSummonCount = 0;
            setTimeout(function () {
                _this.resetData(DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_SUMMON).data);
                console.log(DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_SUMMON).data);
                _this.enabled = true;
                _this.updateIndex(true);
                console.log("召唤成功");
            }, 50);
        }, level, window["CFG"].activityId, this.addLocation);
        /* } else {
            this.enabled = true;
            this.openNoCreditsPanel()
        } */
    };
    MainScene.prototype.doSummonBeforeHome = function (level) {
        var _this = this;
        NetManager_1.NetManager.ins.getHome(function (succuss) {
            if (!succuss) {
                return;
            }
            _this.enabled = true;
            _this.doSummon(level);
            _this.updateIndex(true);
        }, this.getQueryString("dailyMark"), window["CFG"].activityId);
    };
    MainScene.prototype.onError = function (net, desc, result) {
        console.log(desc);
        console.log(result);
        var msg;
        var msgArr = window['errorMessage'];
        if (!isNaN(desc)) {
            msg = msgArr[desc] ? msgArr[desc] : '额哦，一个未知的错误';
        }
        else {
            msg = desc;
        }
        var code = result.code;
        if (code == "0800108") {
            this.showToast("场上狗狗低于6只，不能再回收了");
        }
        else if (code == "0800101") {
            this.showToast("网络异常");
        }
        else if (code == "0800104") {
            this.showToast("该位置没有狗狗,请刷新页面");
        }
        else if (code == "0800105") {
            this.showToast("召唤位置已有狗狗,请刷新页面");
        }
        else if (code == "0800106") {
            //this.showToast("狗粮不足，请晚会再来");
            if (this.doSummonCount == 2) {
                this.enabled = true;
                console.log("狗粮不足，请晚会再来");
                this.openNoCreditsPanel();
                this.updateDogList(false);
            }
        }
        else if (code == "0800108") {
            this.showToast("场上狗狗低于6只，不能再回收了");
        }
        else if (code == "0800107") {
            //this.showToast("合并6级以上狗狗，请先关注公众号");
            this.openHowToGetPrizePanel();
        }
        else if (code == "0800103") {
            this.showToast("狗狗等级位置不符，不能合并");
        }
        else if (code == "0800102") {
            this.showToast("狗狗已是最高等级，不能合并");
        }
        else if (code == "0800101") {
            this.showToast("活动太火爆了，请稍后再来～");
        }
        else if (code == "0300007") {
            this.showToast("操作过于频繁");
        }
        else if (code == "300302") {
            this.showToast("好友成员已满,请稍后再来吧");
        }
        else if (code == "300301") {
            this.showToast("活动期间仅可助力一次");
        }
        else {
            this.showToast(desc);
        }
    };
    MainScene.prototype.onSkinComplete = function () {
        //最大等级
        this.maxLevel = 0;
        //生产速率
        this.yieldRate = 0;
        //粮食库存
        this.foodStocks = 0;
        this.recycleIncome = 0;
        this.firstTipsCoun = 0;
        this.yd_dogMerge.visible = false;
        this.yd_dogAdd.visible = false;
        _super.prototype.onSkinComplete.call(this);
        this.updateIndex();
        this.openWinFrist(0);
        this.bg.texture = this.bgtexture;
        //setTimeout(() => {
        this.addChild(this.starAn);
        this.starAn.touchEnabled = false;
        this.starAn.gotoAndPlay(0);
        this.starAn.visible = false;
        this.isHover = false;
        this.yd_bg.mask = this.rect;
        //}, 2000);
    };
    MainScene.prototype.openWinFrist = function (index) {
        var _this = this;
        if (this.homeData.subscribe == false && index == 4) {
            this.openHowToGetPrizePanel();
        }
        else if (index == 4) {
            this.openWinFrist(5);
        }
        if (this.homeData.dailyBonus && index == 0) {
            this.openPrizePanel(this.homeData.dailyBonus);
        }
        else if (index == 0) {
            this.openWinFrist(2);
        }
        if (this.homeData.hasNewMember && index == 3) {
            this.openOfflineFriendPanel(this.teamData.length);
        }
        else if (index == 3) {
            this.openWinFrist(4);
        }
        if (this.homeData.offlineDuration && index == 5) {
            this.openOfflinePanel(this.homeData.offlineProfit, this.homeData.offlineDuration, this.homeData.maxValidOffLineSecond);
        }
        else if (index == 5) {
            this.openWinFrist(6);
        }
        if (index == 7) {
            this.updateYdTips();
        }
        if (this.homeData.newBonus && index == 2) {
            this.openNewUserPrizePanel(this.homeData.newBonus);
        }
        else if (index == 2) {
            this.openWinFrist(3);
        }
        if (this.getQueryString("shareCode") && index == 6) {
            NetManager_1.NetManager.ins.joinTeam(function (success) {
                if (!success) {
                    return;
                }
                NetManager_1.NetManager.ins.getHome(function (succuss) {
                    if (!succuss) {
                        return;
                    }
                    _this.updateIndex2();
                }, _this.getQueryString("dailyMark"), window["CFG"].activityId);
                _this.openJoinSuccessPanel(DataConversion_1.default.doConversion(DataManager_1.DataManager.ins.getData(NetName_1.NetName.JOINTEAM).data));
            }, this.getQueryString("shareCode"), window["CFG"].activityId);
        }
        else if (index == 6) {
            this.openWinFrist(7);
        }
    };
    MainScene.prototype.getQueryString = function (name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null)
            return unescape(r[2]);
        return null;
    };
    ;
    MainScene.prototype.showStarAn = function (position) {
        this.starAn.visible = true;
        this.starAn.x = position.x - 130;
        this.starAn.y = position.y - 120;
        this.starAn.gotoAndPlay(0);
    };
    MainScene.prototype.updateIndex = function (state) {
        this.homeData = DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_HOME).data;
        if (this.homeData) {
            if (this.homeData.team) {
                this.teamData = this.homeData.team;
            }
            this.dogData = this.homeData.dogs;
            this.updateTeam();
            if (state) {
                //如果state是真，则对最后一名效果添加入场动画
                this.updateDogList(true);
            }
            else {
                this.updateDogList(false);
            }
            this.updateAllTextFromHome();
            if (this.firstTipsCoun == 2) {
                this.updateYdTips();
            }
            this.firstTipsCoun = 2;
        }
    };
    MainScene.prototype.updateIndex2 = function (state) {
        this.homeData = DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_HOME).data;
        if (this.homeData) {
            if (this.homeData.team) {
                this.teamData = this.homeData.team;
            }
            this.dogData = this.homeData.dogs;
            this.updateTeam();
            if (state) {
                //如果state是真，则对最后一名效果添加入场动画
                this.updateDogList(true);
            }
            else {
                this.updateDogList(false);
            }
            this.updateAllTextFromHome();
        }
    };
    MainScene.prototype.updateYdTips = function () {
        var _this = this;
        if (this.dogData.length == 2) {
            if (this.dogData[0].level == 1 && this.dogData[1].level == 1 && this.dogData[0].location < 2 && this.dogData[1].location < 2) {
                //首次达到两只等级为1的狗
                if (!localStorage.firstDogGet) {
                    localStorage.firstDogGet = "1";
                    this.yd_dogMerge.visible = true;
                    this.yd_dogMerge.alpha = 0;
                    setTimeout(function () {
                        _this.yd_dogMerge.alpha = 1;
                    }, 500);
                    this["ydMerge"].play(0);
                    this["ydMerge"].items.forEach(function (item) {
                        item.tween.loop = true;
                    });
                }
            }
        }
        if (this.dogData.length <= 1) {
            var ybState = 1;
            if (this.dogData.length == 1) {
                if (this.dogData[0].level == 1) {
                    ybState = 2;
                }
            }
            else {
                ybState = 3;
            }
            if (ybState == 2) {
                console.log("场景中只有一个等级1的狗");
                if (!localStorage.firstDogAdd1) {
                    localStorage.firstDogAdd1 = "1";
                    this.yd_dogAdd.visible = true;
                    this.yd_dogAdd.alpha = 0;
                    setTimeout(function () {
                        _this.yd_dogAdd.alpha = 1;
                    }, 500);
                    this["ydAddDog"].play(0);
                    this["ydAddDog"].items.forEach(function (item) {
                        item.tween.loop = true;
                    });
                }
            }
            if (ybState == 3) {
                console.log("场景中没有一只狗");
                if (!localStorage.firstDogAdd2) {
                    localStorage.firstDogAdd2 = "1";
                    this.yd_dogAdd.visible = true;
                    this.yd_dogAdd.alpha = 0;
                    setTimeout(function () {
                        _this.yd_dogAdd.alpha = 1;
                    }, 500);
                    this["ydAddDog"].play(0);
                    this["ydAddDog"].items.forEach(function (item) {
                        item.tween.loop = true;
                    });
                }
            }
        }
    };
    MainScene.prototype.isCanMove = function () {
        var state = true;
        if (this.dogData.length == 1) {
            if (this.dogData[0].level == 1) {
                state = false;
            }
        }
        return state;
    };
    //合并
    MainScene.prototype.doMerge = function (currentLevel) {
        var _this = this;
        this.enabled = false;
        NetManager_1.NetManager.ins.getMerge(function (succuss) {
            if (!succuss) {
                _this.enabled = true;
                _this.updateIndex();
                return;
            }
            _this.resetData(DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_MERGE).data);
            setTimeout(function () {
                _this.enabled = true;
                _this.updateIndex();
                _this.showStarAn({ x: _this.dogPositions[_this.to].x, y: _this.dogPositions[_this.to].y });
            }, 50);
        }, this.from, this.to, window["CFG"].activityId);
    };
    MainScene.prototype.resetData = function (Data) {
        this.homeData.dogs = Data.dogs;
        this.homeData.foodStocks = Data.foodStocks;
        this.homeData.maxLevel = Data.maxLevel;
        this.homeData.yieldRate = Data.yieldRate;
        this.homeData.summonLevel = Data.summonLevel;
        this.homeData.summonConsume = Data.summonConsume;
    };
    //修改位置
    MainScene.prototype.doLocation = function () {
        var _this = this;
        this.enabled = false;
        if (this.from == this.to) {
            this.enabled = true;
            this.updateIndex();
            return;
        }
        NetManager_1.NetManager.ins.getLocation(function (succuss) {
            if (!succuss) {
                _this.enabled = true;
                _this.updateIndex();
                return;
            }
            _this.resetData(DataManager_1.DataManager.ins.getData(NetName_1.NetName.GET_LOCATION).data);
            setTimeout(function () {
                _this.enabled = true;
                _this.updateIndex();
            }, 50);
        }, this.from, this.to, window["CFG"].activityId);
    };
    MainScene.prototype.updateAllTextFromHome = function () {
        if (this.homeData.maxLevel) {
            this.maxLevel = this.homeData.maxLevel;
            if (!localStorage.maxLevel) {
                console.log("获得一直新狗");
                console.log(this.maxLevel);
                this.openNewDogShowPanel(this.maxLevel, this.homeData.dogs.length);
            }
            else {
                if (this.maxLevel > parseInt(localStorage.maxLevel)) {
                    console.log("获得一直新狗");
                    this.openNewDogShowPanel(this.maxLevel, this.homeData.dogs.length);
                }
            }
            localStorage.maxLevel = this.maxLevel;
            if (this.maxLevel === 0) {
                this.lvText.text = "LV.0";
            }
            else {
                this.lvText.text = "LV." + this.maxLevel + this.dogLvLists[this.maxLevel - 1];
            }
        }
        if (this.homeData.yieldRate) {
            this.yieldRate = this.homeData.yieldRate;
            this.yieldRateText.text = "+" + DataConversion_1.default.doConversion(this.yieldRate) + "/\u79D2";
        }
        if (this.homeData.foodStocks) {
            this.foodStocks = this.homeData.foodStocks;
            this.foodCountText.text = "" + DataConversion_1.default.doConversion(this.foodStocks);
        }
        if (this.homeData.team) {
            this.teamCountText.text = this.homeData.team.length + "\u4EBA";
        }
        if (this.homeData.team) {
            this.teamCountText.text = this.homeData.team.length + "\u4EBA";
        }
        if (this.homeData.summonConsume && this.homeData.summonLevel) {
            this.addDogBtn.label = "LV." + this.homeData.summonLevel + "\u6D88\u8017" + DataConversion_1.default.doConversion(this.homeData.summonConsume) + "\u72D7\u7CAE";
        }
    };
    MainScene.prototype.updateAllTextFromLocalCount = function () {
        if (this.maxLevel === 0) {
            this.lvText.text = "LV.0";
        }
        else {
            this.lvText.text = "LV." + this.maxLevel + this.dogLvLists[this.maxLevel - 1];
        }
        //this.lvText.text = `LV.${this.maxLevel}${this.dogLvLists[this.maxLevel - 1]}`
        this.yieldRateText.text = "+" + DataConversion_1.default.doConversion(this.yieldRate) + "/\u79D2";
        this.foodCountText.text = "" + DataConversion_1.default.doConversion(this.foodStocks);
    };
    MainScene.prototype.updateTeam = function () {
        for (var i = 0; i < 6; i++) {
            if (this.teamData[i]) {
                this.teams[i].setLoadVal((24 * 60 * 60 - this.teamData[i].remainingTime) / (24 * 60 * 60) * 100);
                console.log("setLoadVal");
                console.log((24 * 60 * 60 - this.teamData[i].remainingTime) / (24 * 60 * 60) * 100);
                this.teams[i].setState(true);
                this.teams[i].setImgUrl(this.teamData[i].avatar);
            }
            else {
                this.teams[i].setState(false);
            }
        }
    };
    MainScene.prototype.updateDogList = function (state) {
        //将位置添加到缓存数据
        this.locationData = [];
        for (var i = 0; i < this.dogData.length; i++) {
            this.locationData.push(this.dogData[i].location);
        }
        //
        if (this.dogPositions.length == 12) {
            for (var i = 0; i < 12; i++) {
                this["doglist_" + i].x = this.dogPositions[i].x;
                this["doglist_" + i].y = this.dogPositions[i].y;
                this["doglist_" + i].canMove = false;
            }
        }
        else {
            for (var i = 0; i < 12; i++) {
                this.dogPositions.push({ x: this["doglist_" + i].x, y: this["doglist_" + i].y, width: this["doglist_" + i].width, height: this["doglist_" + i].height });
            }
        }
        for (var i = 0; i < 12; i++) {
            this.doglists[i].visible = false;
        }
        for (var i = 0; i < this.dogData.length; i++) {
            this["doglist_" + this.dogData[i].location].canMove = true;
            this.doglists[this.dogData[i].location].visible = true;
            this.doglists[this.dogData[i].location].setLv(this.dogData[i].level);
            this.doglists[this.dogData[i].location].setRate("" + DataConversion_1.default.doConversion(this.dogData[i].rate * 3));
        }
        if (state) {
            this.doglists[this.addLocation].firstAn();
        }
    };
    //狗狗产量气泡
    MainScene.prototype.dogRate = function () {
        for (var i = 0; i < 12; i++) {
            this.addGold(i);
        }
    };
    MainScene.prototype.addGold = function (i) {
        var _this = this;
        setTimeout(function () {
            if (_this.doglists[i].visible) {
                _this.music_food.play(0, 1);
            }
            _this.doglists[i].addGold();
        }, 1400 * Math.random());
    };
    MainScene.prototype.start = function (data) {
    };
    MainScene.prototype.onLoad = function () {
        this.initUI();
    };
    MainScene.prototype.initUI = function () {
        //初始化数据
        this.initData();
    };
    MainScene.prototype.initData = function () {
    };
    MainScene.prototype.onEnterFrame = function () {
    };
    //---------------------------------------------------分隔线-----------------------------------------------------
    //图鉴
    MainScene.prototype.onTap_mapBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this.mapBtn);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.DOG_SHOW_PANEL);
    };
    //商店
    MainScene.prototype.onTap_shopBtn = function () {
        var _this = this;
        console.log(this.homeData.foodStocks);
        console.log(this.foodStocks);
        panelCtrl_1.default.instance.btnDelay(this.shopBtn);
        NetManager_1.NetManager.ins.shopYuji(function (success) {
            if (success) {
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHOP_PANEL, _this.foodStocks);
            }
            else {
            }
        }, window["CFG"].activityId);
    };
    //我的奖品记录
    MainScene.prototype.onTap_recordBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this.recordBtn);
        window.location.href = this.gotoRecord();
    };
    //规则按钮
    MainScene.prototype.onTap_ruleBtn = function () {
        panelCtrl_1.default.instance.btnDelay(this.ruleBtn);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RULE_PANEL);
    };
    /**
     * 打开新人奖励狗粮
     * @param newBonus 新人奖励（狗粮）
     */
    MainScene.prototype.openNewUserPrizePanel = function (newBonus) {
        var _this = this;
        console.log("新人奖励（狗粮）:" + newBonus);
        this.wins[2] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, { bgType: 0, type: 0, val1: newBonus, callBack: function () {
                _this.openWinFrist(3);
            } });
        this.winStates[2] = true;
    };
    /**
     * 产生了新的狗狗弹窗
     * @param level 等级
     * @param dogCount 舞台上的狗狗数量
     */
    MainScene.prototype.openNewDogShowPanel = function (level, dogCount) {
        //音效
        this.music_newdog.play(0, 1);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, {
            bgType: 2, type: 7, val1: level, actData: { x: 80, y: this.height - 80 }, callBack: function (iscancel) {
                if (iscancel) {
                    //点击关闭按钮，图鉴按钮放大动画
                    GDispatcher_1.GDispatcher.dispatchEvent("mapBtnAn");
                }
                else {
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHARE_PANEL, { level: level, dNum: dogCount });
                }
            }
        });
    };
    /**
     * 打开离线收益弹窗
     * @param offlineProfit 离线收益
     * @param offlineDuration 离线时间
     * @param maxValidOffLineSecond 最大离线时间(秒)
     */
    MainScene.prototype.openOfflinePanel = function (offlineProfit, offlineDuration, maxValidOffLineSecond) {
        var _this = this;
        console.log("离线收益:" + offlineProfit);
        console.log("最大离线时间:" + offlineDuration);
        this.wins[5] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, { bgType: 3, type: 8, val1: offlineDuration, val2: offlineProfit, val3: maxValidOffLineSecond, callBack: function () {
                _this.openWinFrist(6);
            } });
        this.winStates[5] = true;
    };
    /**
     * 打开离线后新增好友界面
     * @param teamLength 队伍数量
     */
    MainScene.prototype.openOfflineFriendPanel = function (teamLength) {
        var _this = this;
        console.log("队伍数量:" + teamLength);
        this.wins[3] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, { bgType: 1, type: 3, val1: teamLength, callBack: function (iscancel) {
                if (!iscancel) {
                    //打开队伍界面
                    _this.onTap_teamBtn();
                }
                _this.openWinFrist(4);
            } });
        this.winStates[3] = true;
    };
    /**
     * 打开公众号每日福利【获得狗粮】弹窗
     * @param dailyBonus 每日福利狗粮
     */
    MainScene.prototype.openPrizePanel = function (dailyBonus) {
        var _this = this;
        console.log("每日福利狗粮:" + dailyBonus);
        this.wins[0] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, { bgType: 2, type: 6, val1: dailyBonus, callBack: function () {
                _this.openWinFrist(2);
            } });
        this.winStates[0] = true;
    };
    /**
     * 打开公众号每日福利提示弹窗
     */
    MainScene.prototype.openHowToGetPrizePanel = function () {
        var _this = this;
        console.log("打开公众号每日福利提示弹窗:");
        DataConversion_1.default;
        if (!localStorage.HowToGetDate) {
            console.log("首次打开");
            localStorage.HowToGetDate = Date.now();
        }
        else {
            var isSameDay = new DataConversion_1.default().formatTime(new Date(Date.now()), parseInt(localStorage.HowToGetDate));
            if (isSameDay) {
                console.log("今天已经打开过一次");
                this.openWinFrist(5);
                return;
            }
            else {
                console.log("现在可以打开了");
                localStorage.HowToGetDate = Date.now();
            }
        }
        this.wins[4] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, { bgType: 0, type: 2, callBack: function () {
                _this.openWinFrist(5);
            } });
        this.winStates[4] = true;
    };
    /**
     * 打开狗粮不足弹窗
     */
    MainScene.prototype.openNoCreditsPanel = function () {
        console.log("狗粮不足");
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, {
            bgType: 0, type: 1, callBack: function (iscancel) {
                if (!iscancel) {
                    //调用邀请好友方法
                    panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHARE2_PANEL);
                }
            }
        });
    };
    /**
     * 打开确定回收弹窗
     * @param location 位置
     */
    MainScene.prototype.openRecyclePanel = function (location) {
        console.log(6666666);
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, {
            bgType: 1, type: 4, callBack: function (iscancel) {
                if (iscancel) {
                    GDispatcher_1.GDispatcher.dispatchEvent("cancelRecycle");
                }
                else {
                    //点击确认按钮
                    GDispatcher_1.GDispatcher.dispatchEvent("doRecycle", location);
                }
            }
        });
    };
    /**
     * 助力成功
     * @param data
     */
    MainScene.prototype.openJoinSuccessPanel = function (data) {
        var _this = this;
        var text = "\u6C6A\u661F\u536B\u961F\u53C8\u6269\u5145\u529B\u91CF\u5566\n\u9001\u4F60" + data + "\u72D7\u7CAE\u4F5C\u4E3A\u611F\u8C22";
        this.wins[1] = panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.JOIN_PANEL, { text: text, callBack: function () {
                _this.openWinFrist(7);
            } });
        this.winStates[1] = true;
    };
    //获取我的奖品
    MainScene.prototype.gotoRecord = function () {
        var recordUrl;
        var oaId;
        if (DataManager_1.DataManager.ins.customCfgData) {
            oaId = DataManager_1.DataManager.ins.customCfgData.oaId;
            recordUrl = DataManager_1.DataManager.ins.customCfgData.recordUrl;
        }
        else {
            oaId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
            recordUrl = window['recordUrl'];
        }
        if (recordUrl.indexOf('?') != -1) {
            recordUrl += '&origins=' + oaId + '00';
        }
        else {
            recordUrl += '?origins=' + oaId + '00';
        }
        // recordUrl += ',' + (window['plugId'] ? window['plugId'] : 4500) + '01';
        // for(let i = 0; i < window['plugIdArr'].length; i++){
        //     recordUrl += ',' + window['plugIdArr'][i] + '01';
        // }
        return recordUrl;
    };
    return MainScene;
}(Scene_1.default));
exports.default = MainScene;
__reflect(MainScene.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/mainScene/MainScene\".MainScene");
//# sourceMappingURL=MainScene.js.map