import Scene from "../views/Scene";
import MyImage from "./MyImage";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import Panel from "../views/Panel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { FoodItem } from "./FoodItem";
import { Buried } from "../../libs/tw/util/Buried";
import ComponentBase from "../components/ComponentBase";
import GuidePanel from "../guidePanel/GuidePanel";
import { GCache } from "../../libs/tc/util/GCache";
import Loading from "../loading/Loading";
import { GetPrizeInfoData } from "../../libs/tw/data/plug/getPrizeInfo/GetPrizeInfoData";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";

const ADD_SPEED: number = 0.03;
const DISAPPEAR_SP: number = -703;//856
//喂食按钮动画运动时间间隔
const F_TIME_SPACE: number = 600;
//喂食按钮初始角度
const F_ANGLE: number = 7;
//清晨
const MORNING_SECOND = 6 * 3600;
//白天开始
const DAY_SECOND_START = 9 * 3600;
//白天结束
const DAY_SECOND_END = 18 * 3600;

export default class MainScene extends Scene {

	
\

	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }
	constructor(data?) {
		super(data);
		if (data) {
		
		}
	}

	initEvents() {

		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);

	}

	private onError(net: any, code: any): void {
		console.log(code);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(code)) {
			msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';

		} else {
			msg = code;
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
	}
	removeEvents() {
	
		this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);

		// if(this.guideLayer){
		// 	this.removeChild(this.guideLayer);
		// }
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

	}

	start(data?) {
	}

	private bgtexture: egret.Texture;
	protected async preLoadRes() {
		//加载背景并设置背景图片
		this.currBgName = this.getBgNameStr();
		this.bgtexture = await RES.getResAsync(this.currBgName);
		console.log('载背景并设置背景图片mainscene');
		return new Promise(function (resolve, reject) {
			resolve();
		});
	}

	protected onLoad(): void {

		// this.fengche.y = this.stage.stageHeight - 1014;
		this.spDisappear = DISAPPEAR_SP;//this.stage.stageHeight - DISAPPEAR_SP;

		// DataManager.ins.petHomeInfoData.statusRemainingTime += 5;//增加5秒确保服务端时间到期
		//食物容器初始位置取值
		if (!this.fctnPosArr) {
			this.fctnPosArr = [];
		}
		for (var i: number = 0; i < 7; i++) {
			this.fctnPosArr[i] = [this['foodCtner' + i].x, this['foodCtner' + i].y];

			this['foodCtner' + i].touchEnabled = false;
			this['foodCtner' + i].touchChildren = false;
		}


		this.initUI();

		this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}


	private onEnterFrame(): void{

	}

}