console.log("排行榜初始化");
try {
    //数据
    let dataList = [];
    for (let i = 0; i <= 10; i++) {
        dataList.push({
            rank: i + 1,
            nickname: "我是昵称",
            score: 12138
        });
    }

    //item渲染类
    class Item {
        constructor(node, parent, listIndex) {
            this.node = node;
            node.y = listIndex * (itemHeight + itemSpace);
            parent.addChild(node);
            this.labelNickname = node.getChildByName('昵称');
            this.labelScore = node.getChildByName('分数');
            this.labelRank = node.getChildByName("其他排名组").getChildByName("排名");
            this._data = {};
        }
        get data() {
            return this._data;
        }
        set data(v) {
            this._data = v;
            this.dataChanged();
        }

        dataChanged() {
            this.labelNickname.text = this.data.nickname;
            this.labelScore.text = this.data.score.toString();
            this.labelRank.text = this.data.rank.toString();
        }

        destroy() {
            this.node.parent.removeChild(this.node);
        }
    }

    //初始化
    target.renderer = target.removeChildAt(0);
    const renderer = target.renderer;
    let itemList = [];

    //参数
    const itemHeight = target.renderer.height;
    const itemSpace = 4;

    function refresh() {
        target.viewPort.y = 0;

        if (itemList.length > dataList.length) {
            let deleteList = itemList.slice(dataList.length);
            for (let item of deleteList) {
                item.destroy();
            }
            itemList = itemList.slice(0, dataList.length);
        }

        for (let dataIndex = 0; dataIndex < dataList.length; dataIndex++) {
            let item = itemList[dataIndex];
            if (typeof item == "undefined") {
                item = new Item(renderer.clone(), target, dataIndex);
                itemList.push(item);
                item.data = dataList[dataIndex];
            } else {
                item.dataChanged();
            }
        }


    }

    refresh();
} catch (error) {
    console.error(error);
}