import Panel from "../MViews/MPanel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import { isWeiXin } from "../Global/GUtils";

interface DataType {
    imgUrl: string,
    rewardName: string,
    rank: number
}

@Decorator.ClassName("WinningPanel")
export default class WinningPanel extends Panel {
    public labelRank: eui.Label;
    public imgReward: eui.Image;
    public labelRewardName: eui.Label;
    public btnOk: MButton;
    public btnClose: MButton;
    public labelTip: eui.Label;

    data: DataType;
    init(data: DataType) {
        this.data = data;
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.btnOk.onTap(this, () => this.hidePanel());

        let strRank = "-";
        if (typeof this.data.rank == "number") {
            if (this.data.rank > 1000) {
                strRank = "1000+";
            } else {
                strRank = this.data.rank.toString();
            }
        }
        this.labelRank.text = `上期排名第${strRank}，获得`;
        this.labelRewardName.text = this.data.rewardName;
        this.imgReward.source = this.data.imgUrl;
        if (!isWeiXin()) {
            this.labelTip.visible = true;
        }
    }
}