import Panel from "../MViews/MPanel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";
import { isWeiXin } from "../Global/GUtils";

export default class RulePanel extends Panel {
    get skinKey() { return "RulePanel" }
    public text: eui.Label;
    public btnClose: MButton;

    onSkinComplete() {
        super.onSkinComplete();
        let rule = isWeiXin() ? MConfigs.wxRule : MConfigs.appRule;
        this.text.textFlow = new HtmlTextParser().parse(rule);
        this.btnClose.onTap(this, () => this.hidePanel());
    }
}
