import PoolMgr from "./PoolMgr";
import Ball from "../Global/Ball";
import PhycicsSystem from "../Game/PhycicsSystem";
import MTweenMgr from "../MComponents/MTween";
import SoundMgr from "./SoundMgr";
import { MConfigs } from "../Global/MConfigs";
import GuideMask from "../Panel/GuideMask";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import MainScene from "../Scene/MainScene";

export default class GameMgr {
    private static _instance: GameMgr = null;
    public static get instance(): GameMgr {
        if (!this._instance) {
            this._instance = new GameMgr();
        }

        return this._instance;
    }

    public t: number = 0;
    public dropNum: number = 0;

    private mainScene: MainScene = null;
    init(mainScene: MainScene) {
        this.mainScene = mainScene;
    }

    public switchSound() {
        SoundMgr.instance.musicEnabled = !SoundMgr.instance.musicEnabled;
        SoundMgr.instance.effectEnabled = !SoundMgr.instance.effectEnabled;
    }

    public get guideFlag(): boolean {
        return localStorage.getItem("guide") != "false";
    }
    public set guideFlag(v: boolean) {
        localStorage.setItem("guide", v ? "true" : "false");
    }
    private currentGuideMask: GuideMask = null;
    public runGuide(index: number, x: number, y: number, end: boolean = false) {
        this.mainScene.game.pause = true;
        this.currentGuideMask = new GuideMask(index, x, y);
        this.currentGuideMask.onClick = () => {
            this.currentGuideMask && this.currentGuideMask.destroy();
            this.mainScene.game.pause = false;

            if (end) {
                this.guideFlag = false;
            }
        };
        SceneCtrl.instance.parent.addChild(this.currentGuideMask);
    }

    public minEnableCaptchaScore: number = null;
    public leftTimes: number = null;
    public leftShareTimes: number = null;
    public allPeriodEnd: number = null;

    public isWenzhouUser: boolean = false;
}