import Loading from "../../loading/Loading";
import IScene from "../MComponents/IScene";
import Scene from "../MViews/MScene";

export default class SceneCtrl {
    public get parent(): eui.UILayer {
        return this._parent;
    }
    private _parent: eui.UILayer;
    public currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    change(cls: any, data?: any) {
        let scene: Scene = new cls(data);

        if (this.currentScene) {
            let preScene = this.currentScene;
            scene.visible = false;
            scene.onLoaded = () => {
                preScene.destroy();
                scene.visible = true;
            }
        }

        this.currentScene = scene;
        this._parent.addChild(scene);
    }
}