import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';

export default class RulePanel extends Panel {
    public ruleLb:eui.Label;


    public ruleCloseBtn:eui.Button;

    public get skinKey() { return 'RulePanel' }
    public get groupName() { return 'rule_panel' }

    public ruleBg:eui.Image;
    private bgTexture:egret.Texture;

    constructor(data: any) {
        super(data);
    }
    protected async preLoadRes() {

        this.bgTexture = await RES.getResAsync('ruleBg_jpg');
        return new Promise(function (resolve) {
            resolve();
        });
        
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        this.ruleBg.texture = this.bgTexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();

        this.ruleCloseBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.ruleCloseBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    private onLoad():void{
        // NetManager.ins.getRule(function(success){

        //     if(success){
        //         //使用 HtmlTextParser 解析html文本
        //         this.ruleLb.textFlow = new HtmlTextParser().parse(DataManager.ins.getRuleData.ruleText);
        //     }else{
        //         this.ruleLb.text = '规则'
        //     }
        // }.bind(this));

        //this.ruleLb.textColor = 0x031834;
        this.ruleLb.stroke = 0;
        this.ruleLb.text = window['rule'];

        // let startDpmOut = Buried.connectDpm(110, 1, 1); 
        // let startDcmOut = Buried.connectDcm(202, 0, 0);
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        // NetManager.ins.showLog(exposure);
    }
}