import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import PanelCtrl from "../ctrls/panelCtrl";
export default class RankPanel extends Panel {
    public rankScroller:eui.Scroller;
    public rankGroup:eui.Group;
    public prizeBtn:eui.Button;
    public closeBtn:eui.Button;

    public intoRankLb0:eui.Label;
    public nickNameLb:eui.Label;
    public intoRankLb1:eui.Label;
    public totalScoreLb:eui.Label;

    private rankTimesPlugId:number;

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data: any) {
        super(data);
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    private onLoad():void{
        this.rankTimesPlugId = window['rankTimesPlugId'] ? window['rankTimesPlugId'] : 5555;
        this.initUI();
    }

    private initUI():void{
        this.initRankList();

        this.prizeBtn.touchEnabled = false;

        if(DataManager.ins.getInfoData.status.code == 5 && DataManager.ins.realTimeRankData.myUserData.rank < 21){
            this.prizeBtn.visible = true;
            this.closeBtn.x = 70;

            NetManager.ins.getPrizeInfo(function(success){
                if(DataManager.ins.getPrizeInfoList[this.rankTimesPlugId].limitCount > 0){
                    this.prizeBtn.touchEnabled = true;
                    this.prizeBtn.currentState = 'up';
    
    
                }else{
                    this.prizeBtn.touchEnabled = false;
                    this.prizeBtn.currentState = 'disabled';
                }
            }.bind(this), this.rankTimesPlugId);
        }else{
            this.prizeBtn.visible = false;
            this.closeBtn.x = 253;

        }

        
    }

    private initRankList():void{
        const rankDt = DataManager.ins.realTimeRankData;
        for(let i = 0; i < rankDt.userList.length; i++){
            const group = new eui.Group();
            rankDt.userList[i]
            const lineImg = new eui.Image();
            lineImg.source = 'line_rank_png';
            group.addChild(lineImg);

            if(i < 3){
                const img0 = new eui.Image();
                img0.source = 'rankIcon' + i + '_png';
                group.addChild(img0);
                
                img0.x = 28;
                img0.y = 5;
            }else{
                const lb0 = new eui.Label();
                lb0.x = 30;
                lb0.y = 15;
                lb0.width = 50;
                lb0.size = 37;
                lb0.textColor = 0x8c70ca;
                lb0.textAlign = egret.HorizontalAlign.CENTER;
                lb0.text = rankDt.userList[i].rank + '';
                group.addChild(lb0);
            }


            const lb1 = new eui.Label();//昵称
            const lb2 = new eui.Label();//分数
            const img1 = new eui.Image();//奖品图片

            if(i == 0){
                lineImg.y       = 69;
                group.height    = 70;
                lb1.y           = 20;
                lb2.y           = 48;
                img1.y          = 20;
            }else{
                group.height = 60;
                lineImg.y    = 59;
                lb1.y        = 10;
                lb2.y        = 38;
                img1.y       = 12;
            }

            group.width = 573;

            img1.x = 523;
            img1.width = 39;
            img1.height = 39;
            img1.source = window['prizeImgSmall'] ? window['prizeImgSmall'] : 'rankIcon0_png';
            group.addChild(img1);

            lb2.x = 220;
            lb2.size = 22;
            lb2.width = 135;
            lb2.textAlign = egret.HorizontalAlign.CENTER;
            lb2.text = rankDt.userList[i].maxScore + '';
            lb2.textColor = 0xff84eb;
            group.addChild(lb2);

            lb1.x = 220;
            lb1.size = 22;
            lb1.width = 135;
            lb1.textAlign = egret.HorizontalAlign.CENTER;
            lb1.text = rankDt.userList[i].nickName;
            lb1.textColor = 0x8c70ca;
            group.addChild(lb1);

            if(i > 0){
                group.y = i * group.height + 8;
            }
            
            this.rankGroup.addChild(group);
        }

        //初始化当前用户数据
        this.nickNameLb.text = rankDt.myUserData.nickName;
        if(rankDt.myUserData.rank < 21){
            this.intoRankLb1.text = '入榜';
            this.intoRankLb0.text = '恭喜您入榜';

        }else{
            this.intoRankLb1.text = '未入榜';
            this.intoRankLb0.text = '很遗憾未入榜';
        }

        this.totalScoreLb.textFlow = [
			{ text: "累计最高:" },
			{ text: rankDt.myUserData.maxScore + '', style: { "textColor": 0xff84eb } }
		];
    }


    private onTap_prizeBtn():void{
        console.log('点击了立即领取');
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        this.getPlugPrize(this.rankTimesPlugId);
    }
    
    /**
     * 抽首页插件
     * @param idx 插件顺序
     */
    private getPlugPrize(activityId:number):void{
        Loading.instace.show();
        NetManager.ins.doJoinPlugDraw((isSuccess: boolean) => {
            if (isSuccess) {
                NetManager.ins.getPlugOrderStatus((data) => {
                    if (data == 'pollingFaild' || !data) {
                        console.log('轮询失败：' + data);
                        Loading.instace.hide();
                    }else{//出奖
                        Loading.instace.hide();

                        this.prizeBtn.touchEnabled = false;
                        this.prizeBtn.currentState = 'disabled';

                        //弹出奖品框待处理
                        PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL,{callback:function(){}.bind(this), lottery:null});
                    }
                }, DataManager.ins.doJoinPlugDrawData.orderId, () => {
                    return (DataManager.ins.getPlugOrderStatusData.result == 0)
                }, 10)
            } else {
                // 下订单失败
                console.log('抽插件下单失败：' + activityId);
                Loading.instace.hide();
            }
        }, activityId);

    }
}