import { DataManager } from './../manager/DataManager';
import { IExposureData } from '../data/common/IExposureData';
// import { IExposureData } from '..';

export class Buried {
    private static appId: number;
    //private static consumerId: number;
    private static oaId: number;

    /**
     * 初始化
     */
    public static init(): void {
        if(DataManager.ins.gameCfgData) {
            this.appId = DataManager.ins.gameCfgData.appInfo.appId;
            //this.consumerId = DataManager.ins.getInfoData.consumerId;
            this.oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
        } else if(DataManager.ins.customCfgData){
            this.appId = DataManager.ins.customCfgData.appId;
            //this.consumerId = DataManager.ins.customCfgData.consumerId;
            this.oaId = DataManager.ins.customCfgData.oaId ;
        } else if(DataManager.ins.petIndexData && DataManager.ins.petIndexData.appId && DataManager.ins.petIndexData.activityId){
            this.appId = DataManager.ins.petIndexData.appId;
            //this.consumerId = DataManager.ins.petIndexData.consumerId;
            this.oaId = DataManager.ins.petIndexData.activityId ;
        } else if(DataManager.ins.petsIndexData && DataManager.ins.petsIndexData.appId && DataManager.ins.petsIndexData.activityId){
            this.appId = DataManager.ins.petsIndexData.appId;
            //this.consumerId = DataManager.ins.petsIndexData.consumerId;
            this.oaId = DataManager.ins.petsIndexData.activityId ;
        }
    }

    /**
     * 创建dpm埋点数据
     * @param {string} dpm 点击埋点
     * @param {string} dcm 曝光埋点
     * @param {string} dom 
     * @param {string} embedDomain 埋点域名
     * @returns {{dpm: string; domain: string; appId: number}}
     */
    //, 
    public static createExposure(dpm: string, dcm: string, embedDomain = '//embedlog.duiba.com.cn'): IExposureData {
        const exposure: IExposureData = {
            dpm: dpm,
            dcm: dcm,
          

            appId: Buried.appId,
            domain: embedDomain
        };
        return exposure;
    }
    public static createExposureNew(dpm: string, dcm: string, dom: string, embedDomain = '//embedlog.duiba.com.cn'): IExposureData {
        const exposure: IExposureData = {
            dpm: dpm,
            dcm: dcm,
            dom: dom,
    
            appId: Buried.appId,
            domain: embedDomain
        };
        return exposure;
    }
    /**
     * dpm拼接
     * @param pageId 页面ID 
     * @param area 区域
     * @param dpm 埋点号
     * @returns {string}
     */
    public static connectDpm(pageId: number, area: number, dpm: number): string {
        return Buried.appId + '.' + pageId + '.' + area + '.' + dpm;
    }

    /**
     * dcm拼接
     * @param typeId 类型ID
     * @param contentInfo 内容信息
     * @param dcm 埋点号
     * @returns {string}
     */
    public static connectDcm(typeId: number, contentInfo: number, dcm: number): string {
        return typeId + '.' + Buried.oaId + '.' + contentInfo + '.' + dcm;
    }

    public static connectDom(dom: number, a1: number=0, a2: number=0,a3:number=0): string {
        return dom + '.' + a1 + '.' + a2 + '.' + a3;
    }

    /**
     * 插件dcm拼接
     * @param plugId 插件ID
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    public static connectPlugDcm(plugId: number, type: number): string {
        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
    }

    /**
     * 活动dcm拼接
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    public static connectActivityDcm(type: number): string {
        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
    }

}
