/**
 *Created by ck on 2018/5/2
 */
import { Data } from "../Data";
import { PetHomeInfoData } from "./PetHomeInfoData";

export class PetIndexData extends Data {
    /**
     * 积分
     */
    public credits: number = 0;

    /**
     * 积分单位	
     */
    public creditsUnitName: string;

    /**
     * 
     */
    public partnerUserId: string;

    /**
     * appId
     */
    public appId: number=0;

    /**
     * 当前时间
     */
    public currentTime: string;

    /**
     * 是否未登录
     */
    public notLogin: any;

    /**
     * 商品域名
     */
    public goodsDomain:string;

    /**
     * 楼层域名
     */
    public homeDomain:string;

    /**
     * 埋点域名
     */
    public embedDomain:string;

    /**
     * 唤起登录代码
     */
    public openLogin:string;

    /**
     * 登录参数
     */
    public loginProgram:string;

    /**
     * 用户自定义参数
     */
    public dcustom:object = {};

    /**
     * 活动id
     */
    public activityId:number=0;

    /**
     * 用户id
     */
    public consumerId:number=0;

    /**
     * 首页宠物相关信息
     */
    public petHomeInfo: PetHomeInfoData;

    public update(result: any): void {
        if(!result) {
            return;
        }
        if(result.credits){
            this.credits = result.credits;
        }
        if(result.creditsUnitName){
            this.creditsUnitName = result.creditsUnitName;
        }
        if(result.partnerUserId){
            this.partnerUserId = result.partnerUserId;
        }
        if(result.appId){
            this.appId = result.appId;
        }
        if(result.currentTime){
            this.currentTime = result.currentTime;
        }
        if(result.notLogin){
            this.notLogin = result.notLogin;
        }
        if(result.goodsDomain){
            this.goodsDomain = result.goodsDomain;
        }
        if(result.homeDomain){
            this.homeDomain = result.homeDomain;
        }
        if(result.embedDomain){
            this.embedDomain = result.embedDomain;
        }
        if(result.openLogin){
            this.openLogin = result.openLogin;
        }
        if(result.loginProgram){
            this.loginProgram = result.loginProgram;
        }
        if(result.dcustom){
            this.dcustom = result.dcustom;
        }
        if(!isNaN(result.activityId)){
            this.activityId = result.activityId;
        }
        if(!isNaN(result.consumerId)){
            this.consumerId = result.consumerId;
        }
        
        // if(!this.petHomeInfo) {
        //     this.petHomeInfo = new PetHomeInfoData();
        // }
        // this.petHomeInfo.update(result.data);
    }
}