
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";

import { PrizeItemComponent } from "../components/PrizeItemComponent";

import { PopupType } from './../types/sceneTypes';
import Panel from "../views/Panel";

export default class PrizePanel extends Panel {
    private mdata: any;

    public prizeGroup:eui.Group;
    public noPrizeGroup:eui.Group;
    public goToSee:eui.Button
    public backBtn:eui.Button;
    public npPrizeHintLab:eui.Label;
    public prizeIcon:eui.Image;
    public prizeBg:eui.Image;
    public chooseBg:eui.Image;

    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }
    private prizeDataArray:Array<any> = [];
    private prizeData;

    public bg:eui.Image;
    private bgTexture:egret.Texture;

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    protected async preLoadRes() {

        this.bgTexture = await RES.getResAsync('noStartBg_jpg');
        return new Promise(function (resolve) {
            resolve();
        });
        
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        this.bg.texture = this.bgTexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();

        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBackDraw, this); 
        this.goToSee.addEventListener(egret.TouchEvent.TOUCH_TAP,this.goToSee_Tap,this);
        this.prizeBg.addEventListener(egret.TouchEvent.TOUCH_TAP,this.prizeIcon_Tap,this);
    }

    removeEvents(): void {
        super.removeEvents();
    
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBackDraw, this);  
        this.goToSee.addEventListener(egret.TouchEvent.TOUCH_TAP,this.goToSee_Tap,this);
        this.prizeBg.addEventListener(egret.TouchEvent.TOUCH_TAP,this.prizeIcon_Tap,this);
    }

    private onLoad() {
        this.noPrizeGroup.visible = false;
        this.prizeGroup.visible = false;
        this.chooseBg.visible = false;
        this.initUI();
    }

//很遗憾，无中奖纪录下次一定会有好运的哦~
//
    private initUI():void{
       NetManager.ins.getPrizeRecords(function(success: boolean,result){
           console.log("奖品数据",result);
           if(!success)
           {
                this.noPrizeGroup.visible = true;
                this.npPrizeHintLab.text = '网络开小差了\n请稍后重试哦~';
                return;
           }
           for(let i = 0; i < result.data.length; i++){
                let tmpData = result.data[i];
                //微众商品id   过滤谢谢参与
                if(tmpData.appItemId != window['thanks'])
                {
                    this.prizeDataArray.push(tmpData);
                }
            }
            this.prizeShow();
       }.bind(this),DataManager.ins.customCfgData.oaId);
    }
    prizeShow(){
        if(this.prizeDataArray.length > 0 && this.prizeDataArray[0]){
            this.prizeGroup.visible = true;
            this.prizeData = this.prizeDataArray[0];
            this.prizeIcon.source = this.prizeData.imageUrl;
       }else{
            this.prizeGroup.visible = false;
            this.noPrizeGroup.visible = true;
            this.npPrizeHintLab.text = '很遗憾，无中奖纪录\n下次一定会有好运的哦~';
       }
    }
    private onClick(){
        console.log("返回原入口");
        window['wx'].miniProgram.reLaunch({url: '/pages/index'});
    }
    private onClickBackDraw(){
        PanelCtrl.instance.btnDelay(this.backBtn);
        //if(this.mdata && this.mdata.type == 1)
        //{
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            this.hidePanel();
        //}
        // else
        // {
        //     this.getAjax();
        // }
    }
    private getAjax():void{
        Loading.instace.show();
        NetManager.ins.ajaxElementNew(function(success){
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{msgType:PopupType.POPUPTYPE_ABNORMAL_2,
                                        content:["活动过于火爆，",'请稍后前往中奖记录查看是否中奖~']});
                Loading.instace.hide();
            }
        }.bind(this));
    }
    //查看详情
    private goToSee_Tap(){
        console.log("跳转链接",this.prizeData.url)
        window['wx'].miniProgram.navigateTo({url: this.prizeData.url});
        //window['wx'].miniProgram.navigateTo({url: 'https://film.qq.com/weixin/v3/asset/index.html#ticket'});
        //window.location.href = 'https://film.qq.com/weixin/v3/asset/index.html#ticket'
    }
    //选中奖品
    private prizeIcon_Tap(){
        this.chooseBg.visible = !this.chooseBg.visible;
    }
}