
import PanelCtrl from "../ctrls/panelCtrl";

export class PrizeItemComponent extends eui.Component{

    public prizeItemGroup:eui.Group;
    //点击收取回调
    private clickCallBack:Function;

    public prizeName:eui.Label;
    public prizeTime:eui.Label;
    private appItemId:number;//奖品ID
 

    private callBackPrizeName;
    private url:string;
    /**
     * @param appItemId 奖品ID
     * @param prizeName 奖品名字
     * @param prizeTime 奖品时限
     * @param url 跳转链接
     * @param callBack 回调函数
     */
    constructor(appItemId:number, prizeName:string, prizeTime:string,url:string, callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/component/PrizeItemComponent.exml';
     
  
        let tmpPrizeName;
        if(prizeName.length > 13)
        {
            tmpPrizeName = prizeName.substr(0,13) + "...";
        }
        else
        {
            tmpPrizeName = prizeName;
        }
        this.prizeName.text = tmpPrizeName;
        this.prizeTime.text = prizeTime.split(' ')[0];
        this.appItemId = appItemId;
        this.url = url;
        this.callBackPrizeName = prizeName;
        this.clickCallBack  = callBack;
        
        this.prizeItemGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent():void{
        this.prizeItemGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
    }

    private onTap_buyBtn():void{
        if(this.clickCallBack){
            PanelCtrl.instance.btnDelay(this.prizeItemGroup);
            this.clickCallBack(this.appItemId,this.callBackPrizeName,this.url);
        }
    }
}