"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var sceneTypes_1 = require("./../types/sceneTypes");
var Panel_1 = require("../views/Panel");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var Loading_1 = require("../loading/Loading");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var RankPanel = (function (_super) {
    __extends(RankPanel, _super);
    function RankPanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(RankPanel.prototype, "skinKey", {
        get: function () { return 'RankPanel'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RankPanel.prototype, "groupName", {
        get: function () { return 'rank_panel'; },
        enumerable: true,
        configurable: true
    });
    RankPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    };
    RankPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    RankPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    };
    RankPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    };
    RankPanel.prototype.onLoad = function () {
        this.rankTimesPlugId = window['rankTimesPlugId'] ? window['rankTimesPlugId'] : 5555;
        this.initUI();
    };
    RankPanel.prototype.initUI = function () {
        this.initRankList();
        this.prizeBtn.touchEnabled = false;
        if (DataManager_1.DataManager.ins.getInfoData.status.code == 5 && DataManager_1.DataManager.ins.realTimeRankData.myUserData.rank < 21) {
            this.prizeBtn.visible = true;
            this.closeBtn.x = 70;
            NetManager_1.NetManager.ins.getPrizeInfo(function (success) {
                if (DataManager_1.DataManager.ins.getPrizeInfoList[this.rankTimesPlugId].limitCount > 0) {
                    this.prizeBtn.touchEnabled = true;
                    this.prizeBtn.currentState = 'up';
                }
                else {
                    this.prizeBtn.touchEnabled = false;
                    this.prizeBtn.currentState = 'disabled';
                }
            }.bind(this), this.rankTimesPlugId);
        }
        else {
            this.prizeBtn.visible = false;
            this.closeBtn.x = 253;
        }
    };
    RankPanel.prototype.initRankList = function () {
        var rankDt = DataManager_1.DataManager.ins.realTimeRankData;
        for (var i = 0; i < rankDt.userList.length; i++) {
            var group = new eui.Group();
            rankDt.userList[i];
            var lineImg = new eui.Image();
            lineImg.source = 'line_rank_png';
            group.addChild(lineImg);
            if (i < 3) {
                var img0 = new eui.Image();
                img0.source = 'rankIcon' + i + '_png';
                group.addChild(img0);
                img0.x = 28;
                img0.y = 5;
            }
            else {
                var lb0 = new eui.Label();
                lb0.x = 30;
                lb0.y = 15;
                lb0.width = 50;
                lb0.size = 37;
                lb0.textColor = 0x8c70ca;
                lb0.textAlign = egret.HorizontalAlign.CENTER;
                lb0.text = rankDt.userList[i].rank + '';
                group.addChild(lb0);
            }
            var lb1 = new eui.Label(); //昵称
            var lb2 = new eui.Label(); //分数
            var img1 = new eui.Image(); //奖品图片
            if (i == 0) {
                lineImg.y = 69;
                group.height = 70;
                lb1.y = 20;
                lb2.y = 48;
                img1.y = 20;
            }
            else {
                group.height = 60;
                lineImg.y = 59;
                lb1.y = 10;
                lb2.y = 38;
                img1.y = 12;
            }
            group.width = 573;
            img1.x = 523;
            img1.width = 39;
            img1.height = 39;
            img1.source = window['prizeImgSmall'] ? window['prizeImgSmall'] : 'rankIcon0_png';
            group.addChild(img1);
            lb2.x = 220;
            lb2.size = 22;
            lb2.width = 135;
            lb2.textAlign = egret.HorizontalAlign.CENTER;
            lb2.text = rankDt.userList[i].maxScore + '';
            lb2.textColor = 0xff84eb;
            group.addChild(lb2);
            lb1.x = 220;
            lb1.size = 22;
            lb1.width = 135;
            lb1.textAlign = egret.HorizontalAlign.CENTER;
            lb1.text = rankDt.userList[i].nickName;
            lb1.textColor = 0x8c70ca;
            group.addChild(lb1);
            if (i > 0) {
                group.y = i * group.height + 8;
            }
            this.rankGroup.addChild(group);
        }
        //初始化当前用户数据
        this.nickNameLb.text = rankDt.myUserData.nickName;
        if (rankDt.myUserData.rank < 21) {
            this.intoRankLb1.text = '入榜';
            this.intoRankLb0.text = '恭喜您入榜';
        }
        else {
            this.intoRankLb1.text = '未入榜';
            this.intoRankLb0.text = '很遗憾未入榜';
        }
        this.totalScoreLb.textFlow = [
            { text: "累计最高:" },
            { text: rankDt.myUserData.maxScore + '', style: { "textColor": 0xff84eb } }
        ];
    };
    RankPanel.prototype.onTap_prizeBtn = function () {
        console.log('点击了立即领取');
        panelCtrl_1.default.instance.btnDelay(this.prizeBtn);
        this.getPlugPrize(this.rankTimesPlugId);
    };
    /**
     * 抽首页插件
     * @param idx 插件顺序
     */
    RankPanel.prototype.getPlugPrize = function (activityId) {
        var _this = this;
        Loading_1.default.instace.show();
        NetManager_1.NetManager.ins.doJoinPlugDraw(function (isSuccess) {
            if (isSuccess) {
                NetManager_1.NetManager.ins.getPlugOrderStatus(function (data) {
                    if (data == 'pollingFaild' || !data) {
                        console.log('轮询失败：' + data);
                        Loading_1.default.instace.hide();
                    }
                    else {
                        Loading_1.default.instace.hide();
                        _this.prizeBtn.touchEnabled = false;
                        _this.prizeBtn.currentState = 'disabled';
                        //弹出奖品框待处理
                        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.PRIZE_PANEL, { callback: function () { }.bind(_this), lottery: null });
                    }
                }, DataManager_1.DataManager.ins.doJoinPlugDrawData.orderId, function () {
                    return (DataManager_1.DataManager.ins.getPlugOrderStatusData.result == 0);
                }, 10);
            }
            else {
                // 下订单失败
                console.log('抽插件下单失败：' + activityId);
                Loading_1.default.instace.hide();
            }
        }, activityId);
    };
    return RankPanel;
}(Panel_1.default));
exports.default = RankPanel;
__reflect(RankPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/rankPanel/RankPanel\".RankPanel");
//# sourceMappingURL=RankPanel.js.map