import Panel from "../views/Panel";
import { ButtonType } from "../types/sceneTypes";
import SceneCtrl from '../ctrls/sceneCtrl';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import PanelCtrl from "../ctrls/panelCtrl";

export default class ToastPanel extends Panel {
   
 
   
    public backBtn:eui.Group;
    public unShow:eui.Group;
    public unJoin:eui.Group;
    public noStart:eui.Group;

    public startTimeLab:eui.Label;

    private mdata:any;
    public get skinKey() { return 'ToastPanel' }
    public get groupName() { return 'prize_panel'}

  
    start(data) {
        this.mdata = data;
        this.percentHeight = 100;

    }

    onSkinComplete() {
        super.onSkinComplete();
        
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
       
    }

    removeEvents() {
        super.removeEvents();
        this.backBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
    }

    private ontap_this():void{
        super.onTouchTap();
        return;
        if(this.mdata.btnType == ButtonType.TRY_BTN)
        {
            NetManager.ins.ajaxElementNew(function(success){
                if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }else{
                    this.show(ModuleTypes.TOAST_PANEL, {title:'获取失败',content:'请刷新重试',btnType:ButtonType.KNOW_BTN});
                }
            }.bind(this));
        }
        else
        {
            if(this.mdata.btnType != ButtonType.SHATE_BTN)
            {
                if(this.mdata && this.mdata.callBack){
                    this.mdata.callBack();
                }
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }
        }
    }

    private colseBtnClick(){
        super.onTouchTap();
        console.log("返回原入口成功");
        PanelCtrl.instance.btnDelay(this.backBtn);
        //this.hidePanel();
        window['wx'].miniProgram.reLaunch({url: '/pages/index'});
    }
    private onLoad():void{
        if(this.mdata.type == 1)
        {
            this.unShow.visible = true;
            this.unJoin.visible = false;
            this.noStart.visible = false;
        }
        if(this.mdata.type == 2)
        {
            this.unShow.visible = false;
            this.unJoin.visible = true;
            this.noStart.visible = false;
        }
        if(this.mdata.type == 3)
        {
            let getStartTime:string = window['startTime'];
            let startTime = getStartTime.split(' ');
            let showTimeLab = startTime[0].split('-');
            let timeHour = startTime[1].split(':');

            let timeNumber = parseInt(timeHour[0]);
            let timeNumberlab = '';
            if(timeNumber >= 10){
                timeNumberlab = timeHour[0];
            }else{
                let tmpString = timeNumber.toString();
                timeNumberlab = tmpString.substr(tmpString.length - 1,1);
            }
            let showLab = '活动于'+showTimeLab[1]+'月'+showTimeLab[2]+'日'+timeNumberlab+'点'+'开放， 记得来砸蛋哦~';
            
            this.startTimeLab.text = showLab;
            this.unShow.visible = false;
            this.unJoin.visible = false;
            this.noStart.visible = true;
        }

    }
}
export interface IMsgData{
    title:string,
    content:string,
    btnType:number,
    callBack?:Function,
    closeCallBack?:Function
}