
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";

import { PrizeItemComponent } from "../components/PrizeItemComponent";

import Scene from "../views/Scene";
import { PopupType } from './../types/sceneTypes';

export default class PrizePanel extends Scene {
    private mdata: any;

    public showListGroup:eui.Group;
    public prizeGroup:eui.Group;
    public unPrizeGroup:eui.Group;
    public upDateGroup:eui.Group;

    public enterGroupBtn:eui.Group;
    public refreshBtn:eui.Button;
 
    public backGroupBtn:eui.Group;

    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }
    private prizeData:Array<any> = [];
    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.enterGroupBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick, this); 
        this.refreshBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickAgain, this); 
        this.backGroupBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBackDraw, this); 
    }

    removeEvents(): void {
        super.removeEvents();
        this.enterGroupBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick, this);    
        this.refreshBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickAgain, this);  
        this.backGroupBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBackDraw, this);  
    }

    private onLoad() {
        this.initUI();
        
        this.prizeGroup.visible = false;
        this.unPrizeGroup.visible = false;
        this.upDateGroup.visible = false;
 
    }


    private initUI():void{
       NetManager.ins.getPrizeRecords(function(success: boolean,result){
           console.log("奖品数据",result);
           if(!success)
           {
                this.prizeGroup.visible = false;
                this.unPrizeGroup.visible = false;
                this.upDateGroup.visible = true;
                return;
           }
           if(result.data.length > 0){
                this.prizeData = [];
                for(let i = 0; i < result.data.length; i++){
                    let tmpData = result.data[i];
                    //微众商品id   过滤谢谢参与
                    if(tmpData.appItemId != window['thanks'])
                    {
                        this.prizeData.push(tmpData);
                    }
                }
           }else{
                this.prizeGroup.visible = false;
                this.unPrizeGroup.visible = true;
                this.upDateGroup.visible = false;
                return;
           }
           this.handleUI();
       }.bind(this),DataManager.ins.customCfgData.oaId);
    }
    private handleUI(){
        if(this.prizeData.length <= 0)
        {
            this.prizeGroup.visible = false;
            this.unPrizeGroup.visible = true;
            this.upDateGroup.visible = false;
            return;
        }
        let orgX = 0;
        let space = 1;
        this.prizeGroup.visible = true;
        this.unPrizeGroup.visible = false;
        this.upDateGroup.visible = false;
        for(let i = 0; i < this.prizeData.length; i++){
            let tmpData = this.prizeData[i];
            let dItem = new PrizeItemComponent(tmpData.appItemId, tmpData.title, tmpData.gmtCreate,tmpData.url, this.onClickBack.bind(this));
            this.showListGroup.addChild(dItem);
            dItem.x = orgX;
            dItem.y = i * (100 + space);
        }
    }
    private onClickAgain(){
        SceneCtrl.instance.change(ModuleTypes.PRIZE_PANEL);
    }
    private onTap(): void {
        ///this.hidePanel();
       SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
    private onClickBack(appItemId:number,prizeName:string,url:string){
    //     console.log("商品跳转的appItemId",appItemId);
    //    if(window['DirectCharge'].indexOf(appItemId) > -1)
    //    {
    //         PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{boxType:MsgBoxType.MSGBOXTYPE_TWO,
    //                                 btnType:MsgButtonType.MSGBUTTONTYPE_BACK,
    //                                 content:"\"" + prizeName + "\"" + "已充值到你的账户中",
    //                                 BtnText1:"我知道了",});
    //    }
    //    else
    //    {
            console.log("跳转链接",url)
            window['wx'].miniProgram.navigateTo({url: url});
       //}
    }
    onUse() {
    }

    private onClick(){
        console.log("返回原入口");
        PanelCtrl.instance.btnDelay(this.enterGroupBtn);
        window['wx'].miniProgram.reLaunch({url: '/pages/index'});
    }
    private onClickBackDraw(){
        PanelCtrl.instance.btnDelay(this.backGroupBtn);
        if(this.mdata && this.mdata.type == 1)
        {
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            console.log("抽奖界面进入");
        }
        else
        {
            this.getAjax();
        }
    }
    private getAjax():void{
        Loading.instace.show();
        NetManager.ins.ajaxElementNew(function(success){
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{msgType:PopupType.POPUPTYPE_ABNORMAL_2,
                                        content:["活动过于火爆，",'请稍后前往中奖记录查看是否中奖~']});
                Loading.instace.hide();
            }
        }.bind(this));
    }
    private onTap_ok(e:egret.TouchEvent):void{
        // if (this['prizeBtn']) {
        //     PanelCtrl.instance.btnDelay(this['prizeBtn']);
        // }
        this.onUse();
        // window.location.href = window['prizeUrl'] ? window['prizeUrl'] : 'http://www.baidu.com';
        //this.onTouchTap();
    }

}