
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";

import { MsgBoxType } from './../types/sceneTypes';
import { MsgButtonType } from './../types/sceneTypes';
import { PopupType } from './../types/sceneTypes';

export default class MsgPanel extends Panel {
    public labelBtn:eui.Label;
    public closeBtn:eui.Button;

    private mData:any;

    public abNormalGroup_1:eui.Group;
    public abNormalGroup_2:eui.Group;
    public timeTopGroup:eui.Group;
    public winPrizeGroup:eui.Group;
    public noTimeGroup:eui.Group;
    public noStockGroup:eui.Group;
    public noPrizeGroup:eui.Group;

    public goTryBtn:eui.Button;
    public getRecordBtn:eui.Button;
    public msgKonwBtn1:eui.Button;
    public goGetBtn:eui.Button;
    public goBuyBtn:eui.Button;
    public msgKonwBtn2:eui.Button;
    public msgKonwBtn3:eui.Button;
    public goBuyPrizeBtn:eui.Button;
    
   
    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
        
    }
    private prizeMap:any;
    onSkinComplete():void{
        super.onSkinComplete();
      
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }
    protected async preLoadRes() {
       
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickCloseBtn, this);
        this.goTryBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoTryBtn, this);
        this.getRecordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickgetRecordBtn, this);
        this.msgKonwBtn1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);
        this.goGetBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoGetBtn, this);
        this.goBuyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoBuyBtn, this);
        this.msgKonwBtn2.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);
        this.msgKonwBtn3.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);

        this.goBuyPrizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoBuyBtn, this);
        
    }

    removeEvents():void{
        super.removeEvents();
        this.goTryBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoTryBtn, this);
        this.getRecordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickgetRecordBtn, this);
        this.msgKonwBtn1.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);
        this.goGetBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoGetBtn, this);
        this.goBuyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoBuyBtn, this);
        this.msgKonwBtn2.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);
        this.msgKonwBtn3.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickMsgKonwBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickCloseBtn, this);

        this.goBuyPrizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickGoBuyBtn, this);
    }

    private onLoad():void{
        this.initUI();
        
    }

    private initUI(){
        this.abNormalGroup_1.visible = false;
        this.abNormalGroup_2.visible = false;
        this.timeTopGroup.visible = false;
        this.winPrizeGroup.visible = false;
        this.noTimeGroup.visible = false;
        this.noStockGroup.visible = false;
        this.noPrizeGroup.visible = false;
        if(this.mData){
            switch (this.mData.msgType) {
                case PopupType.POPUPTYPE_ABNORMAL_1:
                        this.handlePopupUI(this.abNormalGroup_1);
                    break;
                case PopupType.POPUPTYPE_ABNORMAL_2:
                        this.handlePopupUI(this.abNormalGroup_2);
                    break;
                case PopupType.POPUPTYPE_TIMETOPLIMIT:
                        this.handlePopupUI(this.timeTopGroup);
                    break;
                case PopupType.POPUPTYPE_NOTIME:
                    this.handlePopupUI(this.noTimeGroup);
                    break;
                case PopupType.POPUPTYPE_WINPRIZE:
                        //this.handlePopupUI(this.winPrizeGroup);
                        this.setPrize(this.winPrizeGroup);
                    break;
                case PopupType.POPUPTYPE_NOSTOCK:
                        this.handlePopupUI(this.noStockGroup);
                    break;
                case PopupType.POPUPTYPE_NOPRIZE:
                        this.handlePopupUI(this.noPrizeGroup);
                    break;
                default:
                    break;
            }
        }else{
            console.log('弹窗数据出错');
        }
    }
    private setPrize(winPrizeGroup){
        if(this.mData.icon)
        {
            let url: string;
            url = this.mData.icon;
            let iconNode = winPrizeGroup.getChildByName("itemIcon");
            iconNode.name = 'img';
            iconNode.source = url;
            iconNode.width = 250;
            iconNode.height = 250;

            let tmpPrizeName = this.mData.content;
            if(this.mData.content.length > 13)
            {
                tmpPrizeName = this.mData.content.substr(0,13) + "...";
            }
            winPrizeGroup.getChildByName("hintLab1").text = tmpPrizeName;
        }
        if(!this.mData.url)
        {
            this.goGetBtn.visible = false;
            this.goBuyPrizeBtn.visible = true;
        }else{
            this.goGetBtn.visible = true;
            this.goBuyPrizeBtn.visible = false;
        }
        winPrizeGroup.visible = true;
    }
    private handlePopupUI(nodeUI){
        if(this.mData.content.length > 1)
        {
            let noTimelab1:eui.Label = nodeUI.getChildByName('hintLab1') as eui.Label;
            let noTimelab2:eui.Label = nodeUI.getChildByName('hintLab2') as eui.Label;
            noTimelab1.visible = true;
            noTimelab2.visible = true;
            noTimelab1.text = this.mData.content[0];
            noTimelab2.text = this.mData.content[1];
        }
        if(this.mData.content.length <= 1)
        {
            nodeUI.getChildByName('hintLab2').visible = false;
            let noTimelab:eui.Label = nodeUI.getChildByName('hintLab1') as eui.Label;
            noTimelab.visible = true;
            noTimelab.text = this.mData.content[0];
            nodeUI.getChildByName('hintLab2')
        }
        nodeUI.visible = true;
    }
    private onClickCloseBtn(e:egret.TouchEvent){
        let curButton:eui.Button = e.target;
        PanelCtrl.instance.btnDelay(curButton);
        this.hidePanel();
        this.getAjax();
    }

    private onClickGoTryBtn(e:egret.TouchEvent){
        console.log("稍后重试");
        let curButton:eui.Button = e.target;
        PanelCtrl.instance.btnDelay(curButton);
        this.hidePanel();
        this.getAjax();
    }

    private onClickgetRecordBtn(e:egret.TouchEvent){
        console.log("查看中奖记录");
        let curButton:eui.Button = e.target;
        PanelCtrl.instance.btnDelay(curButton);
        SceneCtrl.instance.change(ModuleTypes.PRIZE_PANEL);
        this.hidePanel();
        //this.getAjax();
    }

    private onClickMsgKonwBtn(e:egret.TouchEvent){
        console.log("我知道了");
        let curButton:eui.Button = e.target;
        PanelCtrl.instance.btnDelay(curButton);
        this.hidePanel();
        if(this.mData.msgType == PopupType.POPUPTYPE_TIMETOPLIMIT || this.mData.msgType == PopupType.POPUPTYPE_NOSTOCK){
            window['wx'].miniProgram.reLaunch({url: '/pages/index'});
        }else{
            this.getAjax();
        }
        
    }

    private onClickGoGetBtn(e:egret.TouchEvent){
        console.log("去领取");
        let curButton:eui.Button = e.target;
        PanelCtrl.instance.btnDelay(curButton);
        //url:"/pages/coupon/prize?id=" + DataManager.ins.doJoinData.orderId + "&receive=true"
        if(this.mData && this.mData.url)
        {
            console.log("跳转的url----",this.mData.url);
            window['wx'].miniProgram.navigateTo({url: this.mData.url});
        }
        else
        {
            console.log("跳转的url出错",this.mData.url);
        }
    }

    private onClickGoBuyBtn(){
        console.log("去消费");
        window['wx'].miniProgram.reLaunch({url: '/pages/index'});
    }

    private getAjax():void{
        Loading.instace.show();
        NetManager.ins.ajaxElementNew(function(success){
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL,{msgType:PopupType.POPUPTYPE_ABNORMAL_1,
                                        content:["活动过于火爆，",'请稍后再试~']});
                Loading.instace.hide();
            }
        }.bind(this));
    }


}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}