import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
export default class GameOverPanel extends Panel {
 

    public icon:eui.Image;
    public reset:eui.Button;
    //public share:eui.Button;
    private mData:any;

    //语文老师 13>=   <=15
    private chinese:egret.Texture;
    //英语老师 11>=   <13
    private english:egret.Texture;
    //数学老师 8>=   <11
    private mathematics:egret.Texture;
    //体育老师 5>=   <8
    private sports:egret.Texture;
    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }
    protected async preLoadRes() {
        this.chinese = await RES.getResAsync("chinese_png");
        this.english = await RES.getResAsync("english_png");
        this.mathematics = await RES.getResAsync("mathematics_png");
        this.sports = await RES.getResAsync("sports_png");
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.reset.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        //this.share.addEventListener(egret.TouchEvent.TOUCH_TAP, this.shareOnClick, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.reset.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        //this.share.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.shareOnClick, this);
    }

    private onLoad():void{
        this.intiData();
    }

    private intiData(){
        if(5 <= this.mData.score && this.mData.score < 8)
        {
            this.setTexture(this.icon,this.sports);
        }
        else if(8 <= this.mData.score && this.mData.score < 11)
        {
            this.setTexture(this.icon,this.mathematics);
        }
        else if(11 <= this.mData.score && this.mData.score < 13)
        {
            this.setTexture(this.icon,this.chinese);
        }
        else if(13 <= this.mData.score && this.mData.score <= 15)
        {
            this.setTexture(this.icon,this.english);
        }
        else
        {
            console.log('分数出错');
        }
    }
    private setTexture(tmpNode,tmpTexture){
        tmpNode.texture =  tmpTexture;
        tmpNode.width = tmpTexture.width;
        tmpNode.height = tmpTexture.height;
    }
    private onTap_againBtn():void{
        PanelCtrl.instance.btnDelay(this.reset);
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        this.hidePanel();
        this.goHome();
    }

    private goHome():void{
        NetManager.ins.ajaxElementNew(function(success){
            console.log(DataManager.ins.ajaxElementDataNew);
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"活动提示",content:"活动太火爆了，请稍后再来",btnLabel:"确定"});
            }
        }.bind(this));
    }
    private shareOnClick(){
        //PanelCtrl.instance.btnDelay(this.share);
        this.hidePanel();
        //PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL, {score:this.mData.score});
    }

    private jietu(){
        // if (document.getElementById("saveImage")) {
        //     document.getElementById("saveImage")["src"] = this.dataUrl;
        //     document.getElementById("saveImage").style.display = "block";
        // } else {
            // document.getElementById("cusEngine").style.position = "absolute";
            // var imageShow = new Image();
            // imageShow["src"] = this.dataUrl;
            // imageShow.id = "saveImage";
            // document.body.appendChild(imageShow);
            // imageShow.style.position = "absolute";
            // // image.style.width = "70%";
            // var w = StageManager.ins.stage.divWidth;
            // imageShow.style.width = w + "px";
            // //为了缩小
            // var h = (1000 / 750 * StageManager.ins.stage.divWidth + 0.5) >> 0;
            // imageShow.style.height = h + "px";
            // imageShow.style.opacity = "0";
        //}
    }

    public static getPrintScreenData(scene, startX, startY, width, height): any {
        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(scene, new egret.Rectangle(startX, startY, width, height));
        // egret.updateAllScreens();
        let imageData = renderTexture.toDataURL("image/png");
        return imageData;
      }
}