import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
export default class DescribePanel extends Panel {
    public nameLb:eui.Label;
    public desLb:eui.Label;
    private mdata:any;

    public get skinKey() { return 'DescribePanel' }
    public get groupName() { return 'describe_panel'}
    
    constructor(data){
        super(data);

        this.mdata = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        

        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();

        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    private onLoad():void{
        if(this.mdata){
            this.desLb.text = this.mdata[0];
            this.nameLb.text = this.mdata[1];
        }
        
    }


    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
    }
}