"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var Loading_1 = require("../loading/Loading");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var GameOverPanel = (function (_super) {
    __extends(GameOverPanel, _super);
    function GameOverPanel(data) {
        var _this = _super.call(this, data) || this;
        _this.mData = data;
        return _this;
    }
    Object.defineProperty(GameOverPanel.prototype, "skinKey", {
        get: function () { return 'GameOverPanel'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameOverPanel.prototype, "groupName", {
        get: function () { return 'gameover_panel'; },
        enumerable: true,
        configurable: true
    });
    GameOverPanel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.effectImg.visible = false;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct(function () {
            this.effectImg.visible = true;
            egret.Tween.get(this.effectImg, { loop: true }).to({ rotation: 360 }, 5000);
        }.bind(this));
    };
    GameOverPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    GameOverPanel.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    GameOverPanel.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    };
    GameOverPanel.prototype.onLoad = function () {
        if (this.mData) {
            var fCountArr = this.mData.fcountArr;
            var socreArr = this.mData.scoreArr;
            for (var i = 0; i < fCountArr.length; i++) {
                this['flowerCountLb' + i].text = 'x' + fCountArr[i];
                var sign = '';
                if (i < 3) {
                    sign = '+';
                }
                this['socreLb' + i].text = sign + fCountArr[i] * socreArr[i] + '分';
            }
            this.scoreLb.text = this.mData.score + '';
            //首页是否有领取礼包
            this.prizeTipsImg.visible = this.mData.hasPrize > 0 ? true : false;
            this.bestScoreLb.text = '历史最高成绩:' + DataManager_1.DataManager.ins.getInfoData.maxScore + '分';
        }
    };
    GameOverPanel.prototype.onTap = function () {
        panelCtrl_1.default.instance.btnDelay(this.okBtn);
        this.hidePanel();
        if (this.mData) {
            this.mData.callBack();
        }
        //获取游戏信息
        Loading_1.default.instace.show();
        NetManager_1.NetManager.ins.getInfo(function (success) {
            if (success) {
            }
            else {
                //提示用户，返回上一层，重新进入活动？？？？？
                panelCtrl_1.default.instance.showMsg('okBtn', 4, null, null, '请刷新重试！');
            }
            Loading_1.default.instace.hide();
        });
    };
    GameOverPanel.prototype.onTouchTap = function () {
        _super.prototype.onTouchTap.call(this);
        if (this['closeBtn']) {
            panelCtrl_1.default.instance.btnDelay(this['closeBtn']);
        }
        this.onTap();
    };
    return GameOverPanel;
}(Panel_1.default));
exports.default = GameOverPanel;
__reflect(GameOverPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/gameOverPanel/GameOverPanel\".GameOverPanel");
//# sourceMappingURL=GameOverPanel.js.map