"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var GameModel_1 = require("../common/GameModel");
var DataManager_1 = require("./../../manager/DataManager");
var TwLang_1 = require("../../util/TwLang");
var GFun_1 = require("../../../tc/util/GFun");
var GameWinnerModel = (function (_super) {
    __extends(GameWinnerModel, _super);
    function GameWinnerModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 排名文案
     * @param rankStr
     */
    GameWinnerModel.prototype.getRankTxt = function (rankStr) {
        if (rankStr === void 0) { rankStr = TwLang_1.TwLang.lang_020; }
        if (DataManager_1.DataManager.ins.winRanksData.consumer.rank == "?") {
            return GFun_1.GFun.replace(TwLang_1.TwLang.lang_019, [DataManager_1.DataManager.ins.winRanksData.consumer.rank || '0']);
        }
        return GFun_1.GFun.replace(rankStr, [DataManager_1.DataManager.ins.winRanksData.consumer.rank]);
    };
    /**
     * 奖品文案
     * @param winningStr
     * @param notWinningStr
     * @param notJoinStr
     */
    GameWinnerModel.prototype.getOptionTxt = function (winningStr, notWinningStr, notJoinStr) {
        if (winningStr === void 0) { winningStr = TwLang_1.TwLang.lang_021; }
        if (notWinningStr === void 0) { notWinningStr = TwLang_1.TwLang.lang_022; }
        if (notJoinStr === void 0) { notJoinStr = TwLang_1.TwLang.lang_024; }
        var str;
        //是否参与过游戏
        if (DataManager_1.DataManager.ins.winRanksData.consumer.join) {
            //是否中奖
            if (DataManager_1.DataManager.ins.winRanksData.consumer.option) {
                str = GFun_1.GFun.replace(winningStr, [DataManager_1.DataManager.ins.winRanksData.consumer.option]);
            }
            else {
                str = notWinningStr;
            }
        }
        else {
            str = notJoinStr;
        }
        return str;
    };
    /**
     * 用户ID文案
     * @param str
     */
    GameWinnerModel.prototype.getConsumerTxt = function (str) {
        if (str === void 0) { str = TwLang_1.TwLang.lang_023; }
        return GFun_1.GFun.replace(str, [DataManager_1.DataManager.ins.winRanksData.consumer.cid]);
    };
    Object.defineProperty(GameWinnerModel.prototype, "rankList", {
        /**
         * 排行列表
         */
        get: function () {
            return DataManager_1.DataManager.ins.winRanksData.rankList;
        },
        enumerable: true,
        configurable: true
    });
    return GameWinnerModel;
}(GameModel_1.GameModel));
exports.GameWinnerModel = GameWinnerModel;
__reflect(GameWinnerModel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/libs/tw/model/game/GameWinnerModel\".GameWinnerModel");
//# sourceMappingURL=GameWinnerModel.js.map