import { ModuleTypes } from './../types/sceneTypes';
import ComponentBase from "../components/ComponentBase";
import SceneCtrl from "../ctrls/sceneCtrl";

export default class Toast extends ComponentBase {

    public get skinKey() { return "Toast" }

    public msgTxt: eui.Label;

    private _msg: string;

    constructor(msg) {
        super();
        if (msg) {
            this._msg = msg;
        }
        this._msg = msg
        this.msgTxt.text = this._msg;
    }


    initEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
        )
    }
    removeEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
        )
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }

}