import { NetManager } from './../../libs/tw/manager/NetManager';
import Panel from "../views/Panel";

export default class FirstSignPrizePanel extends Panel {
    public get skinKey() { return "FirstSignPrize" }

    public sureBtn: eui.Button;

    private _scene: any;

    constructor(scene) {
        super();
        this._scene = scene;

        NetManager.ins.showLog(this._scene.createExposure("xrqd"))
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.sureBtn, this.onTouchTap);
    }

    onTouchTap() {
        super.onTouchTap();
        NetManager.ins.clickLog(this._scene.createExposure("xrqd"))
        this._scene.isGuide();
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.sureBtn, this.onTouchTap);
    }
}