import { weidianNet } from './../NetConst';
import { ModuleTypes } from './../types/sceneTypes';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import ToastCtrl from '../ctrls/toastCtrl';
import SceneCtrl from '../ctrls/sceneCtrl';
import Waiting from '../waiting/Waiting';
import PanelCtrl from '../ctrls/panelCtrl';

export default class ShopScene extends Scene {
    public get skinKey() { return "Shop" }

    public friendsGroup: eui.Group;
    public inviteBtn: eui.Image;
    public stealBtn: eui.Group;
    public getConponBtn: eui.Button;
    public myCoffeeStoreBtn: eui.Button;
    public shopName: eui.Label;
    public shopLevel: eui.Label;
    public type: eui.Label;
    public reduce: eui.Label;
    public full: eui.Label;
    public time: eui.Label;
    public itemsGroup: eui.Group;


    constructor() {
        super();
        this.percentHeight = 100;
        this.percentWidth = 100;
        this.initUI();
    }

    initUI() {
        const { coupon, items, shop } = DataManager.ins.getData("getShopDetail").data;
        const shopsList = DataManager.ins.getData("getShopsInfo") && DataManager.ins.getData("getShopsInfo").data && DataManager.ins.getData("getShopsInfo").data.shops ? DataManager.ins.getData("getShopsInfo").data.shops : [];
        const friendsList = DataManager.ins.getData("getFriendsInfo") && DataManager.ins.getData("getFriendsInfo").data && DataManager.ins.getData("getFriendsInfo").data.friends ? DataManager.ins.getData("getFriendsInfo").data.friends : [];
        const stealable = DataManager.ins.getData("getShopStatus").success;

        this.shopName.text = this.fixName(shop.shopName, 8);

        if (coupon) {
            this.type.text = coupon.type
            this.full.text = coupon.full;
            this.reduce.text = coupon.reduce;
            this.time.text = coupon.time;
            this.onTap(this.getConponBtn, () => {
                window.location.href = coupon.couponUrl
            })
        }

        if (items && items.length > 0) {
            for (let i = 0; i < Math.min(items.length, 3); i++) {
                // let item = items[i];
                let goodsItem = new eui.Component();
                goodsItem.skinName = "ShopItemSkin";
                goodsItem.x = i * 180;
                goodsItem['itemPic'].source = items[i].itemPic;
                goodsItem['itemPic'].mask = goodsItem['itemMask'];
                goodsItem['itemName'].text = this.fixName(items[i].itemName, 16);
                goodsItem['itemPrice'].text = "￥" + (items[i].itemPrice / 100).toFixed(2);
                goodsItem['itemOriginalPrice'].text = (items[i].itemOriginalPrice / 100).toFixed(2);
                goodsItem['itemOriginalPrice'].x = goodsItem['itemPrice'].x + goodsItem['itemPrice'].width + 10;
                goodsItem['line'].width = goodsItem['itemOriginalPrice'].width + 8;
                goodsItem['line'].x = goodsItem['itemOriginalPrice'].x - 3;
                this.itemsGroup.addChild(goodsItem);
                this.onTap(goodsItem, () => {
                    window.location.href = items[i].itemUrl;
                })
            }
        }

        if (stealable) {
            this.stealBtn.visible = true;
            this.onTap(this.stealBtn, this.onTap_stealBtn)
        } else {
            this.stealBtn.visible = false;
        }


        let i = 0;
        if (shopsList.length > 0) {
            shopsList.forEach(shopItem => {
                let shop = new eui.Component();
                shop.skinName = "FriendItemSkin"
                shop.x = i * 120;
                shop.y = 5;
                shop['avatar'].source = shopItem.shopLogo;
                shop['avatar'].mask = shop['avatarMask'];
                shop['nameTxt'].text = this.fixName(shopItem.shopName);
                shop['shopId'] = shopItem.shopId;
                this.friendsGroup.addChild(shop);
                this.onTap(shop, this.onTap_shop);
                i++;
            });

        }

        if (friendsList.length > 0) {
            friendsList.forEach(friendItem => {
                let friend = new eui.Component();
                friend.skinName = "FriendItemSkin"
                friend.x = i * 120;
                friend.y = 5;
                friend['avatar'].source = friendItem.avatar;
                friend['avatar'].mask = friend['avatarMask'];
                friend['nameTxt'].text = this.fixName(friendItem.nickname);
                friend['friendUserId'] = friendItem.friendUserId;
                this.friendsGroup.addChild(friend);
                this.onTap(friend, this.onTap_friend)
                i++;
            });
        }

        this.inviteBtn.x = i * 120;

    }


    initEvents() {
        super.initEvents();
        this.onTap(this.inviteBtn, this.onTap_inviteBtn);
        this.onTap(this.myCoffeeStoreBtn, this.onTap_myCoffeeStoreBtn)
    }

    onTap_stealBtn() {
        Waiting.instance.show();
        weidianNet.stealShopGold((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("偷取失败，请重试~")
                return
            }
            ToastCtrl.instance.show(`成功偷取${500}金币`);
            this.stealBtn.visible = false;
        }, DataManager.ins.getData("getShopDetail").data.shop.shopId, window['projectxId'])
    }

    onTap_friend(e) {
        Waiting.instance.show();
        let friendUserId = e.$target.$parent.friendUserId;
        weidianNet.getFriendDetail((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开了点小差，请稍后再试~")
                return
            }
            SceneCtrl.instance.change(ModuleTypes.MINOR_SCENE, friendUserId);
        }, friendUserId, window['projectxId'])
    }

    onTap_shop(e) {
        Waiting.instance.show();
        let shopId = e.$target.$parent.shopId;
        weidianNet.getShopDetail((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("网络开了点小差，请稍后再试~")
                return
            }
            weidianNet.getShopStatus((ss) => {
                Waiting.instance.hide();
                SceneCtrl.instance.change(ModuleTypes.SHOP_SCENE);
            }, shopId, window['projectxId'])
        }, shopId, window["projectxId"])
    }

    // 邀请好友
    onTap_inviteBtn() {
        PanelCtrl.instance.show(ModuleTypes.INVITE_PANEL)
    }

    onTap_myCoffeeStoreBtn() {
        weidianNet.index((s) => {
            if (!s) {
                ToastCtrl.instance.show("网络开了点小差，请稍后再试~")
                return
            }
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
        }, window['projectxId'])
    }

    removeEvents() {
        super.removeEvents();
    }

    fixName(name, num = 4) {
        let nameArr = name.split("");
        if (nameArr.length < num) {
            return name;
        } else {
            let _name = ""
            for (let i = 0; i < num; i++) {
                _name += nameArr[i];
            }
            _name += "..."
            return _name;
        }

    }
}