import { Buried } from '../../libs/tw/util/Buried';
import { LotteryType } from '../../libs/tw/enum/LotteryType';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetManager } from '../../libs/tw/manager/NetManager';
import { ModuleTypes } from '../types/sceneTypes';
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
import NetConst from '../NetConst';
import PanelCtrl from '../ctrls/panelCtrl';
import GameConst from '../GameConst';
import Waiting from '../waiting/Waiting';
import ImgSizeType from './data/ImgSizeType';
import getOptionImgSize from './data/getOptionImgSize';

export default class PrizePanel extends Panel {
    protected get skinKey() { return 'Prize' }

    public light: eui.Image;
    public bg: eui.Image;
    public img: eui.Image;
    public closeBtn: eui.Button;
    public prizeName: eui.Label;
    public useBtn: eui.Button;



    private _lottery: any;
    private useExposure: any;

    get lottery() { return this._lottery || DataManager.ins.getData("getOrderStatus").data.lottery; }
    get picWidth() { return 250 };
    get picBigWidth() { return 500 };
    get bigPicRatio() { return 640 / 300 }

    constructor(lottery) {
        super();
        this._lottery = lottery;

        this.initBuired();
        this.initUI();
        this.initAni();
        // NetManager.ins.showLog(this._scene.createExposure("cjxhgd"))
    }

    initBuired() {

    }

    initUI() {

        if (this.lottery) {
            const sizeType = getOptionImgSize(this.lottery);
            this.log(this.lottery)
            if (ImgSizeType.BIG === sizeType) {

                this.img.width = this.picBigWidth;
                this.img.height = this.picBigWidth / this.bigPicRatio;
            } else {
                this.img.width = this.img.height = this.picWidth;
            }
            this.prizeName.text = this.lottery.title;
            this.img.source = this.lottery.imgUrl || this.lottery.img;
            this.img.y = 630;
            this.img.anchorOffsetX = 250 / 2;
            this.img.anchorOffsetY = 250 / 2;
        }
    }

    initAni() {
        egret.Tween.get(this.light, { loop: true })
            .to({ rotation: 360 }, 5000)
    }


    initEvents() {
        this.img.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.useBtn.once(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onTap_closeBtn(e) {
        this.hidePanel();
    }

    onUse() {
        if (this.lottery.type == LotteryType.LUCKY) {

            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getPlugOrderStatusData.exposure);
            }
        } else {
            window.location.href = DataManager.ins.getPlugOrderStatusData.lottery.link;
        }

    }

    removeEvents() {
        // this.clearTap(this.acceptBtn, this.onUse);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }
}