import { Buried } from './../../libs/tw/util/Buried';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
import NetConst from '../NetConst';
import PanelCtrl from '../ctrls/panelCtrl';
import GameConst from '../GameConst';

export default class NoPrizePanel extends Panel {
    protected get skinKey() { return 'NoPrize' }

    public bg: eui.Image;
    public closeBtn0: eui.Button;
    public closeBtn1: eui.Button;


    private scene: any;
    private againBtnExposure: any;

    constructor(data?) {
        super();
        this.initBuired();
        this.initAni();
    }

    initBuired() {

        let againDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
        let againDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.againBtnExposure = Buried.createExposure(againDpmOut, againDcmOut);

        NetManager.ins.showLog(this.againBtnExposure);
    }


    initAni() {
        // egret.Tween.get(this.againBtn, { loop: true })
        //     .to({ scaleX: 1.05, scaleY: 1.05 }, 200)
        //     .to({ scaleX: 0.95, scaleY: 0.95 }, 400)
        //     .to({ scaleX: 1, scaleY: 1 }, 200)
    }


    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn0, this.onTap_closeBtn);
        this.onTap(this.closeBtn1, this.onTap_closeBtn)
    }

    onTap_closeBtn(e) {
        NetManager.ins.clickLog(this.againBtnExposure)
        this.hidePanel();

    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn0, this.onTap_closeBtn);
        this.clearTap(this.closeBtn1, this.onTap_closeBtn);
    }
}