import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Ani from "../mainScene/Ani";
import GameConst from "../GameConst";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Waiting from "../waiting/Waiting";
export default class UpLevelPanel extends Panel{
    protected get skinKey(){  return 'pop/UpLevel' }

    public closeBtn:eui.Button;
    public upshowBtn:eui.Button;
    public uptext:eui.Label;
    public leveltext:eui.Label;
    public reward:eui.Label;
    public rewardtype:eui.Image;
    public rewardnum:eui.Label;

    public func :any;

    private uid:any;
    private scene:any;

    constructor(data){
        super();
        this.initUI(data);
        this.scene = data.scene;
        this.uid = data.partnerUserId;
    }

    initUI(data){
        
        this.uptext.text = "恭喜店长，\n店铺成功升级到Lv"+data.storeLevel+"啦~"
        if(data.storeLevel<10){
            this.leveltext.x = 450;
        }else{
            this.leveltext.x = 440;
        }
        if(data.upgradeReward){
            this.rewardnum.text = data.upgradeReward;
        }else{
            this.reward.visible = false;
            this.rewardnum.visible = false;
            this.rewardtype.visible = false;
        }
        
        this.func = this.onTap_closeBtn.bind(this,data);
        this.onTap(this.closeBtn,this.func);
    }

    initEvents(){
        //super.initEvents();
        //this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.upshowBtn,this.onTap_show);
    }

    onTap_closeBtn(data){
        
        //主页面增加钻石数
        Waiting.instance.show();
        weidianNet.index(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel();
            
            await Ani.instance.awardDiamondAni(this.scene);
            
            data.scene.updateData();
            this.scene.updateDiamond(DataManager.ins.getData("index").data.diamond);
            // await Ani.instance.awardCoinAni(data.scene);
            if(data.chickenNewEnable || data.exchangeNewEnable || data.grabNewEnable){
                let pumpdata = {storeLevel:data.storeLevel,chickenNewEnable:data.chickenNewEnable,grabNewEnable:data.grabNewEnable,exchangeNewEnable:data.exchangeNewEnable,scene:data.scene}
                PanelCtrl.instance.show(ModuleTypes.PUMPED_PANEL,pumpdata);
            }
            
            
        }, window['projectxId'])
    }
    onTap_show(){
        //分享弹窗
        Waiting.instance.show();
        weidianNet.getInviteCode((s)=>{
            Waiting.instance.hide();
            if(!s){
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode,this.uid);
            weidianNet.index((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                //this.slideDown()
                this.scene.updateData()
                this.hidePanel();
            }, window['projectxId'])
        },window['projectxId'])
    }

    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.upshowBtn,this.onTap_show);
    }
}