import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Waiting from "../waiting/Waiting";
import Ani from "../mainScene/Ani";
export default class TaskPanel extends Panel {
    protected get skinKey() { return 'pop/Task' }
    public closeBtn: eui.Button;
    public taskList: eui.Scroller;
    public taskeGroup: eui.Group;
    public taskevery: eui.Group;
    public day1: eui.Image;
    public day2: eui.Image;
    public day3: eui.Image;
    public day4: eui.Image;
    public day5: eui.Image;
    public get1: eui.Label;
    public get2: eui.Label;
    public get3: eui.Label;
    public get4: eui.Label;
    public get5: eui.Label;
    public clockBtn: eui.Button;
    public task1lab:eui.Label;
    public task2lab:eui.Label;
    public task3lab:eui.Label;
    public task4lab:eui.Label;
    public task5lab:eui.Label;
    public task6lab:eui.Label;

    public task1: eui.Group;
    public task1Btn: eui.Button;
    public counttime: eui.Label;
    public task2: eui.Group;
    public task2Btn: eui.Button;
    public task3: eui.Group;
    public task3Btn: eui.Button;
    public task4: eui.Group;
    public task4Btn: eui.Button;
    public task5: eui.Group;
    public task5Btn: eui.Button;
    public task6: eui.Group;
    public task6Btn: eui.Button;
    public task7: eui.Group;
    public task7Btn: eui.Button;

    public havefinish: eui.Label;
    public finished: eui.Label;
    public haveget: eui.Label;
    public geted: eui.Label;

    private functask1: any;
    private functask2: any;
    private functask3: any;
    private functask4: any;
    private functask5: any;
    private functask6: any;
    private functask7: any;
    public _data: any;
    private scene: any;
    private uid:any;
    private signdate:number = 0;

    constructor(data) {
        super();
        this.percentHeight = 100;
        this.percentWidth = 100;
        this._data = data.data;
        this.initUI(this._data);
        this.scene = data.scene;
        this.uid = data.partnerUserId;

    }
    //

    initUI(data) {
        this.taskList.height = GameConst.stage.stageHeight * 3 / 5;
        //taskevery
        if (data.dayInfos) {

            for (let i = 0; i < 5; i++) {
                this["day" + (i + 1)].visible = data.dayInfos[i].sign;
                if(i<4){
                    this["get" + (i + 1)].text = GameConst.tranNumber(data.dayInfos[i].coins,1);
                }else{
                    this["get" + (i + 1)].text = GameConst.tranNumber(data.dayInfos[i].diamonds);
                }
                
            }
            for(let n = 0; n < 5; n++) {
                if(data.dayInfos[n].sign == false){
                    this.signdate = n;
                    break;
                }
            }

        }
        if (data.sign) {
            this.setColor(this.clockBtn);
            this.clearTap(this.clockBtn, this.onTap_clockBtn);
        }

        //task1 每日领金币 倒计时 是否已领取奖励
        this._data = data;
        this.task1lab.text = "每天7-9点、13-15点、18-21点,\n可免费领取1000"
        //task1 领取每日金币
        this.counttime.visible = false;
        if (data.takeCoinsTask.takeSign) {
            this.task1Btn.icon = "task1Btn1_png"
            this.onTap(this.task1Btn, this.onTap_task1Btn);
        } else {
            let hour = new Date().getHours();
            let issign: boolean = false;
            if (hour >= 7 && hour < 9) {
                issign = true;
            } else if (hour >= 13 && hour < 15) {
                issign = true;
            } else if (hour >= 18 && hour < 21) {
                issign = true;
            } else {
                issign = false;
            }
            if (issign) {
                this.task1Btn.icon = "task1Btn2_png"
                this.clearTap(this.task1Btn, this.onTap_task1Btn);
            } else {
                this.counttime.visible = true;
                this.task1Btn.icon = "btnBG_png";
                //this.counttime.text = data.takeCoinsTask[0].nextTakeTime;
                this.clearTap(this.task1Btn, this.onTap_task1Btn);
            }
        }
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame.bind(this, this._data), this);


        //task2 每日分享
        if (data.shareTask) {
            //task2状态
            if (data.shareTask.status == 2) {
                this.task2Btn.icon = "task1Btn2_png";
                this.setColor(this.task2Btn);
                this.clearTap(this.task2Btn, this.functask2);
            } else if (data.shareTask.status == 1) {
                this.task2Btn.icon = "task1Btn1_png";
                this.functask2 = this.onTap_task2Btn.bind(this, data.shareTask.status);
                this.onTap(this.task2Btn, this.functask2)
            } else if (data.shareTask.status == 0) {
                this.task2Btn.icon = "task2Btn1_png";
                this.functask2 = this.onTap_task2Btn.bind(this, data.shareTask.status);
                this.onTap(this.task2Btn, this.functask2)
            }
            this.task2lab.text = "每天分享，可获得"+GameConst.tranNumber(data.shareTask.coins);
        }
        //task3 浏览
        if (data.browseTask) {
            if (data.browseTask.status == 2) {
                this.task3Btn.icon = "task1Btn2_png";
                this.setColor(this.task3Btn);
                this.clearTap(this.task3Btn, this.functask3);
            } else if (data.browseTask.status == 1) {
                this.task3Btn.icon = "task1Btn1_png";
                this.functask3 = this.onTap_task3Btn.bind(this, data.browseTask.status, data);
                this.onTap(this.task3Btn, this.functask3)
            } else if (data.browseTask.status == 0) {
                this.task3Btn.icon = "task3Btn1_png";
                this.functask3 = this.onTap_task3Btn.bind(this, data.browseTask.status, data);
                this.onTap(this.task3Btn, this.functask3)
            }
            this.task3lab.text = "浏览指定商品60s以上，\n可获得"+GameConst.tranNumber(data.browseTask.coins);
        }

        //task4 邀请开店
        if (data.openShopTask) {
            
            if (data.openShopTask.status == 2) {
                this.task4Btn.icon = "tomorrow_png";
                //this.setColor(this.task4Btn);
                this.clearTap(this.task4Btn, this.functask4);
            } else if (data.openShopTask.status == 1) {
                this.task4Btn.icon = "task1Btn1_png";
                this.havefinish.text = "待领取   次"
                this.finished.text = data.openShopTask.unclaimed;
                this.functask4 = this.onTap_task4Btn.bind(this, data.openShopTask.status, data);
                this.onTap(this.task4Btn, this.functask4)
            } else if (data.openShopTask.status == 0) {
                this.task4Btn.icon = "task4Btn1_png";
                this.havefinish.text = "已完成   次"
                this.finished.text = data.openShopTask.completed;
                this.functask4 = this.onTap_task4Btn.bind(this, data.openShopTask.status, data);
                this.onTap(this.task4Btn, this.functask4)
            }
            this.task4lab.text = "邀请好友开店，可获得\n"+GameConst.tranNumber(data.openShopTask.diamonds)+"     "+GameConst.tranNumber(data.openShopTask.coins);
        }
        //task5 邀请下载
        if (data.downloadTask) {
            this.geted.text = data.downloadTask.unclaimed;
            if (data.downloadTask.status == 2) {
                this.task5Btn.icon = "tomorrow_png";
                //this.setColor(this.task5Btn);
                this.clearTap(this.task5Btn, this.functask5);
            } else if (data.downloadTask.status == 1) {
                this.task5Btn.icon = "task1Btn1_png";
                this.haveget.text = "待领取   次"
                this.geted.text = data.downloadTask.unclaimed;
                this.functask5 = this.onTap_task5Btn.bind(this, data.downloadTask.status, data);
                this.onTap(this.task5Btn, this.functask5)
            } else if (data.downloadTask.status == 0) {
                this.task5Btn.icon = "task4Btn1_png";
                this.haveget.text = "已完成   次"
                this.geted.text = data.downloadTask.completed;
                this.functask5 = this.onTap_task5Btn.bind(this, data.downloadTask.status, data);
                this.onTap(this.task5Btn, this.functask5)
            }
            this.task5lab.text = "邀请好友下载微店APP，\n可获得"+GameConst.tranNumber(data.downloadTask.diamonds)+"     "+GameConst.tranNumber(data.downloadTask.coins);
        }
        //task6 前往购物
        if (data.orderTask) {
            if (data.orderTask.status == 2) {
                this.task6Btn.icon = "task1Btn2_png";
                this.setColor(this.task6Btn);
                this.clearTap(this.task6Btn, this.functask6);
            } else if (data.orderTask.status == 1) {
                this.task6Btn.icon = "task1Btn1_png";
                this.functask6 = this.onTap_task6Btn.bind(this, data.orderTask.status, data);
                this.onTap(this.task6Btn, this.functask6)
            } else if (data.orderTask.status == 0) {
                this.task6Btn.icon = "task6Btn1_png";
                this.functask6 = this.onTap_task6Btn.bind(this, data.orderTask.status, data);
                this.onTap(this.task6Btn, this.functask6)
            }
            this.task6lab.text = "去指定页面下单成功，可获得\n"+GameConst.tranNumber(data.orderTask.diamonds)+"     "+GameConst.tranNumber(data.orderTask.coins);
        }
    }

    initEvents() {
        //super.initEvents();
        this.onTap(this.clockBtn, this.onTap_clockBtn);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    onEnterFrame(data) {
        
        //倒计时
        let now = new Date();
        let hour = now.getHours();
        if (hour < 7) {
            this.task1Btn.icon = "btnBG_png";
            this.getTimeDiff(7);
        } else if (hour >= 9 && hour < 13) {
            this.task1Btn.icon = "btnBG_png";
            this.getTimeDiff(13);
        } else if (hour >= 15 && hour < 18) {
            this.task1Btn.icon = "btnBG_png";
            this.getTimeDiff(18);
        } else if (hour >= 21) {
            this.task1Btn.icon = "btnBG_png";
            this.getTimeDiff(7);
        }
    }
    getTimeDiff(endTime) {
        let now:any = new Date();
        let year: any = now.getFullYear();
        let month: any = now.getMonth() + 1;
        let day: any = now.getDate();
        let hour = now.getHours();
        if (month < 10) {
            month = "0" + month;
        }
        if (day < 10) {
            day = "0" + day;
        }
        if (endTime < 10) {
            endTime = "0" + endTime;
        }
        endTime = year + "-" + month + "-" + day + " " + endTime + ":00:00";
        var date2 = new Date(endTime);    //结束时间
        if (hour >= 21) {
            var date3 = date2.getTime() - now.getTime() + 24 * 60 * 60 * 1000;
        } else {
            var date3 = date2.getTime() - now.getTime();  //时间差的毫秒数
        }

        //计算出小时数
        var leave1 = date3 % (24 * 3600 * 1000);    //计算天数后剩余的毫秒数
        var hours: any = Math.floor(leave1 / (3600 * 1000));
        //计算相差分钟数
        var leave2 = leave1 % (3600 * 1000);        //计算小时数后剩余的毫秒数
        var minutes: any = Math.floor(leave2 / (60 * 1000));
        //计算相差秒数
        var leave3 = leave2 % (60 * 1000);      //计算分钟数后剩余的毫秒数
        var seconds: any = Math.round(leave3 / 1000);
        //alert(" 用时： " + days + "天 " + hours + "小时 " + minutes + " 分钟" + seconds + " 秒")

        if (seconds < 10) {
            seconds = "0" + seconds;
        } else if (seconds == 60) {
            seconds = "00";
            minutes += 1;
        }
        if (hours < 10) {
            hours = "0" + hours;
        }
        if (minutes < 10) {
            minutes = "0" + minutes;
        }

        this.counttime.text = hours + ":" + minutes + ":" + seconds;
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }

    onTap_clockBtn() {
        //接口
        Waiting.instance.show();
        weidianNet.doSign(async(s) => {
            Waiting.instance.hide();
            if (!s) {
                if(DataManager.ins.getData("doSign").message){
                    ToastCtrl.instance.show(DataManager.ins.getData("doSign").message);
                }else{
                    ToastCtrl.instance.show("打卡失败，请重试~")
                }
                return
            }
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            ToastCtrl.instance.show("今日打卡成功")
            this.setColor(this.clockBtn);
            this.clockBtn.touchChildren = false;
            this.clockBtn.touchEnabled = false;
            this.clearTap(this.clockBtn, this.onTap_clockBtn);
            if(DataManager.ins.getData("getTaskInfo").data.data.dayInfos[this.signdate+1].diamonds>0){
                await Ani.instance.awardDiamondAni(this);
            }else{
                await Ani.instance.awardCoinAni(this);
            }
            let data = DataManager.ins.getData("doSign").data;
            this.scene.updateData();
            this.scene.updateCoin(data.nowCoins);
            this.scene.updateDiamond(data.nowDiamonds);
            if(data.storeUpgrade){
                let taskevedata = {storeLevel:data.storeLevel,upgradeReward:data.upgradeReward,chickenNewEnable:data.chickenNewEnable,feeNewEnable:data.feeNewEnable,grabNewEnable:data.grabNewEnable,exchangeNewEnable:data.exchangeNewEnable,partnerUserId:this.uid,scene:this.scene};
                this.hidePanel();
                PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL,taskevedata);
            }
            
        }, window['projectxId'])
    }

    onTap_task1Btn() {
        //接口
        Waiting.instance.show();
        weidianNet.getCoin((s) => {
            Waiting.instance.hide();
            if (!s) {
                if(DataManager.ins.getData("getCoin").message){
                    ToastCtrl.instance.show(DataManager.ins.getData("getCoin").message);
                }else{
                    ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                }
                return
            }
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            this.task1Btn.icon = "task1Btn2_png";
            this.clearTap(this.task1Btn, this.onTap_task1Btn)
        }, window['projectxId'])
    }

    //status == 1完成任务 status==2领取奖励
    onTap_task2Btn(status) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.doShare((s) => {
                Waiting.instance.hide();
                if (!s) {
                    if(DataManager.ins.getData("doShare").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("doShare").message);
                    }else{
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                weidianNet.getTaskInfo((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.initUI(data)
                }, window['projectxId'])
                this.clearTap(this.task2Btn, this.functask2);
                this.task2Btn.icon = "task1Btn2_png";
            }, window['projectxId'])
        } else if (status == 0) {
            //分享接口
            //回调
            Waiting.instance.show();
            weidianNet.getInviteCode((s)=>{
                Waiting.instance.hide();
                if(!s){
                    ToastCtrl.instance.show("分享失败，请重试~");
                    return
                }
                let sharecode = DataManager.ins.getData("getShopStatus").data;
                window['shareWX'](sharecode,this.uid);
                weidianNet.goShare((s)=>{
                    if(!s){
                        ToastCtrl.instance.show("分享失败，请重试~")
                        return
                    }
                    weidianNet.getTaskInfo((s) => {
                        if (!s) {
                            ToastCtrl.instance.show("更新任务失败，请重试~")
                            return
                        }
                        let data = DataManager.ins.getData("getTaskInfo").data
                        this.initUI(data)
                    }, window['projectxId'])
                    this.task2Btn.icon = "task1Btn1_png";
                    this.clearTap(this.task2Btn, this.functask2);
                    this.functask2 = this.onTap_task2Btn.bind(this, 1);
                    this.onTap(this.task2Btn, this.functask2);
                }, window['projectxId'])
            },window['projectxId'])
            
            
        }
    }

    onTap_task3Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                Waiting.instance.hide();
                if (!s) {
                    if(DataManager.ins.getData("takeReward").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    }else{
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                weidianNet.getTaskInfo((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.initUI(data)
                }, window['projectxId'])
                this.clearTap(this.task3Btn, this.functask3);
                this.task3Btn.icon = "task1Btn2_png";
            }, "browse", window['projectxId'])
        } else if (status == 0) {
            //浏览商品接口
            //回调
            window.location.href = data.browseTask.url;
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            this.task3Btn.icon = "task1Btn1_png";
            this.clearTap(this.task3Btn, this.functask3);
            this.functask3 = this.onTap_task3Btn.bind(this, 1);
            this.onTap(this.task3Btn, this.functask3);
        }
    }
    onTap_task4Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                Waiting.instance.hide();
                if (!s) {
                    if(DataManager.ins.getData("takeReward").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    }else{
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                weidianNet.getTaskInfo((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.initUI(data)
                }, window['projectxId'])
                //this.clearTap(this.task4Btn, this.functask4);
                this.task4Btn.icon = "task1Btn2_png";
            }, "open", window['projectxId'])
        } else if (status == 0) {
            //邀请开店接口
            //回调
            window.location.href = data.openShopTask.url;
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            this.task4Btn.icon = "task1Btn1_png";
            this.clearTap(this.task4Btn, this.functask4);
            this.functask4 = this.onTap_task4Btn.bind(this, 1);
            this.onTap(this.task4Btn, this.functask4);
        }
    }
    onTap_task5Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                Waiting.instance.hide();
                if (!s) {
                    if(DataManager.ins.getData("takeReward").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    }else{
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                weidianNet.getTaskInfo((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.initUI(data)
                }, window['projectxId'])
                //this.clearTap(this.task5Btn, this.functask5);
                this.task5Btn.icon = "task1Btn2_png";
            }, "download", window['projectxId'])
        } else if (status == 0) {
            //邀请下载接口
            //回调
            window.location.href = data.downloadTask.url;
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            this.task5Btn.icon = "task1Btn1_png";
            this.clearTap(this.task5Btn, this.functask5);
            this.functask5 = this.onTap_task5Btn.bind(this, 1);
            this.onTap(this.task5Btn, this.functask5);
        }
    }
    onTap_task6Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                Waiting.instance.hide();
                if (!s) {
                    if(DataManager.ins.getData("takeReward").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    }else{
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                weidianNet.getTaskInfo((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.initUI(data)
                }, window['projectxId'])
                this.clearTap(this.task6Btn, this.functask6);
                this.task6Btn.icon = "task1Btn2_png";
            }, "order", window['projectxId'])
        } else if (status == 0) {
            //购买好物接口
            //回调
            window.location.href = data.orderTask.url;
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.initUI(data)
            }, window['projectxId'])
            this.task6Btn.icon = "task1Btn1_png";
            this.clearTap(this.task6Btn, this.functask6);
            this.functask6 = this.onTap_task6Btn.bind(this, 1);
            this.onTap(this.task6Btn, this.functask6);
        }
    }

    onTap_closeBtn() {
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide()
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.scene.updateData()
            this.slideDown()
        }, window['projectxId'])
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.clockBtn, this.onTap_clockBtn);
        this.clearTap(this.task1Btn, this.onTap_task1Btn);
        this.clearTap(this.task2Btn, this.functask2);
        this.clearTap(this.task3Btn, this.functask3);
        this.clearTap(this.task4Btn, this.functask4);
        this.clearTap(this.task5Btn, this.functask5);
        this.clearTap(this.task6Btn, this.functask6);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame.bind(this, this._data), this)

    }

}