import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import Waiting from "../waiting/Waiting";
import { DataManager } from "../../libs/tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class SignPanel extends Panel {
    protected get skinKey() { return 'pop/Sign' }
    public closeBtn: eui.Button;
    public right1: eui.Image;
    public right2: eui.Image;
    public right3: eui.Image;
    public right4: eui.Image;
    public right5: eui.Image;
    public getCoinBtn: eui.Button;

    public day1Img: eui.Image;
    public day2Img: eui.Image;
    public day3Img: eui.Image;
    public day4Img: eui.Image;
    public day5Img: eui.Image;

    public day1: eui.Label;
    public day2: eui.Label;
    public day3: eui.Label;
    public day4: eui.Label;
    public day5: eui.Label;

    private func: any;
    private scene: any;
    private uid:any;
    private sign:any;

    private signdate:number = 0;
    constructor(data) {
        super();
        let _data = data.data;
        this.scene = data.scene;
        this.uid = data.partnerUserId;
        this.sign = data.sign;
        this.initUI(_data)
    }
    initUI(data) {
        this.right1.visible = false;
        this.right2.visible = false;
        this.right3.visible = false;
        this.right4.visible = false;
        this.right5.visible = false;

        if (data.dayInfos) {
            for (let i = 0; i < 5; i++) {
                if (data.dayInfos[i].diamonds > 0) {
                    this["day" + (i + 1) + "Img"].source = "popdia_png";
                    this["day" + (i + 1)].text = data.dayInfos[i].diamonds;
                } else {
                    this["day" + (i + 1) + "Img"].source = "signcoin_png";
                    this["day" + (i + 1)].text = data.dayInfos[i].coins;
                }

                this["right" + (i + 1)].visible = data.dayInfos[i].sign
            }
            for(let n = 0; n < 5; n++) {
                if(data.dayInfos[n].sign == false){
                    this.signdate = n;
                    break;
                }
            }
        }
        if(this.sign){
            this.func = this.onTap_getCoin.bind(this, false);
            this.onTap(this.getCoinBtn, this.func);
        }else{
            this.func = this.onTap_getCoin.bind(this, true);
            this.onTap(this.getCoinBtn, this.func);
        }
        
    }
    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    onTap_getCoin(type) {
        //接口
        if(type){
            ToastCtrl.instance.show("今日已经领过金币了哦~");
        }else{
            Waiting.instance.show()
            weidianNet.doSign(async (s) => {
                Waiting.instance.hide()
                if (!s) {
                    if(DataManager.ins.getData("doSign").message){
                        ToastCtrl.instance.show(DataManager.ins.getData("doSign").message);
                    }else{
                        ToastCtrl.instance.show("打卡失败，请重试~")
                    }
                    return
                }
                this.setColor(this.getCoinBtn);
                this.clearTap(this.getCoinBtn, this.func);
                this.func = this.onTap_getCoin.bind(this, true);
                this.onTap(this.getCoinBtn, this.func);
                this["right"+(this.signdate+1)].visible = true;
                if(DataManager.ins.getData("getTaskInfo").data.data.dayInfos[this.signdate+1].diamonds>0){
                    await Ani.instance.awardDiamondAni(this);
                }else{
                    await Ani.instance.awardCoinAni(this);
                }
                //await Ani.instance.awardCoinAni(this);
                let data = DataManager.ins.getData("doSign").data;
                this.scene.updateData();
                this.scene.updateCoin(data.nowCoins);
                this.scene.updateDiamond(data.nowDiamonds);
                if(data.storeUpgrade){
                    let signdata = {storeLevel:data.storeLevel,upgradeReward:data.upgradeReward,exchangeNewEnable:data.exchangeNewEnable,chickenNewEnable:data.chickenNewEnable,feeNewEnable:data.feeNewEnable,grabNewEnable:data.grabNewEnable,partnerUserId:this.uid,scene:this.scene};
                    this.hidePanel();
                    PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL,signdata);
                }
                
            }, window['projectxId']);
        }
    }


    onTap_closeBtn() {
        this.hidePanel();
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.getCoinBtn, this.func);
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
}