import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import GameConst, { wait } from "../GameConst";
import Waiting from "../waiting/Waiting";
export default class SharePanel extends Panel {
    protected get skinKey() { return 'pop/Share' }
    public closeBtn:eui.Button;
    public wxshareBtn:eui.Button;
    public sharelab:eui.Label;
    private uid:any;

    private scene:any;
    constructor(data){
        super();
        this.scene = data.scene;
        this.uid = data.partnerUserId;
        this.sharelab.text = "好友加入游戏即可添加成功邀请成功可获得    "+GameConst.tranNumber(window['coinsnum'])+"， "+GameConst.tranNumber(window['dianum'])
    }

    initEvents(){
        //super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.wxshareBtn,this.onTap_shareBtn);
    }
    onTap_closeBtn(){
        //this.hidePanel();
        //SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            //this.slideDown()
            this.scene.updateData()
            this.hidePanel();
        }, window['projectxId'])
    }
    onTap_shareBtn(){
        //分享唤起
        Waiting.instance.show();
        weidianNet.getInviteCode((s)=>{
            Waiting.instance.hide();
            if(!s){
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode,this.uid);
            weidianNet.index((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                //this.slideDown()
                this.scene.updateData()
                this.hidePanel();
            }, window['projectxId'])
        },window['projectxId'])
       
    }
}