import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
export default class RevenuePanel extends Panel{
    protected get skinKey(){  return 'pop/Revenue' }
    public shareBtn:eui.Button;
    public closeBtn:eui.Button;
    public revenuenum:eui.Label;
    private scene:any;
    private uid:any;

    constructor(data){
        super();
        this.scene = data.scene;
        this.initUI(data);
        this.uid = data.partnerUserId;
    }

    initUI(data){
        this.revenuenum.text = data.coin;
    }
    initEvents(){
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.shareBtn,this.onTap_shareBtn);

    }

    onTap_closeBtn(){
        //领取coin type = 服务员
        Waiting.instance.show();
        weidianNet.waiterGold((s)=>{
            Waiting.instance.hide();
            if(!s){
                ToastCtrl.instance.show("活动太火爆了，请稍后再来~");
                return
            }
            weidianNet.index(async(s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                this.hidePanel()
                await Ani.instance.awardCoinAni(this.scene);
            }, window['projectxId'])
        },window['projectxId'],false);
    }
    onTap_shareBtn(){
        //分享弹窗
        //弹窗跳起
        Waiting.instance.show();
        weidianNet.getInviteCode((s)=>{
            Waiting.instance.hide();
            if(!s){
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode,this.uid);
            weidianNet.waiterGold((s)=>{
                if(!s){
                    ToastCtrl.instance.show("活动太火爆了，请稍后再来~");
                    return
                }
                weidianNet.index(async(s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新数据失败，请重试~")
                        return
                    }
                    this.hidePanel()
                    await Ani.instance.awardCoinAni(this.scene);
                }, window['projectxId'])
            },window['projectxId'],true);
        },window['projectxId'])
        
        
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.shareBtn,this.onTap_shareBtn);
    }
} 