import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
export default class PumpedPanel extends Panel {
    protected get skinKey() { return 'pop/Pumped' }
    public textImg:eui.Image;
    public pumpBtn:eui.Button;
    public closeBtn:eui.Button;

    private scene:any;
    constructor(data){
        super();
        
        this.initUI(data);
    }
    initUI(data){
        this.scene = data.scene;
        if(data.chickenNewEnable){
            this.textImg.source = "pumpedtext_png"//打鸡血
            this.textImg.width = 510;
            this.textImg.height = 175;
            this.pumpBtn.icon = "pumpedBtn_png"
        }
        if(data.grabNewEnable){
            this.textImg.source = "oktext_png"//抢单
            this.textImg.width = 510;
            this.textImg.height = 175;
            this.pumpBtn.icon = "okBtn_png"
        }
            
        if(data.exchangeNewEnable){
            this.textImg.source = "changetext_png"//兑换
            this.textImg.width = 510;
            this.textImg.height = 79;
            this.pumpBtn.icon = "changeBtn_png"
        }
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.pumpBtn,this.onTap_closeBtn);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
    }

    onTap_closeBtn(){
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel();
            this.scene.updateData();
        }, window['projectxId'])
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.pumpBtn,this.onTap_closeBtn);
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
    }
}