import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class LeavePanel extends Panel{
    protected get skinKey(){  return 'pop/Leave' }
    public closeBtn:eui.Button;
    public leaveBtn:eui.Button;
    public nextBtn:eui.Button;
    private scene:any;


    constructor(data){
        super();
        this.scene = data.scene;
    }

    initEvents(){
        //super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.nextBtn,this.onTap_closeBtn);
        this.onTap(this.leaveBtn,this.onTap_leave);
    }
    onTap_closeBtn(){
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide()
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.scene.updateData();
            this.hidePanel()
        }, window['projectxId'])


    }
    onTap_leave(){
        //退出游戏
        
        window['LeaveGame']();
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.nextBtn,this.onTap_closeBtn);
        this.clearTap(this.leaveBtn,this.onTap_leave);
    }

}