import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";

export default class GuideNewPanel extends Panel {
    protected get skinKey() { return 'pop/GuideNew' }

    public closeBtn: eui.Button;
    public startBtn: eui.Button;
    public newlab: eui.Label;

    private scene: any;


    constructor(data) {

        super();
        
        
        this.scene = data.scene;
        this.newlab.text = "亲爱的店长，\n欢迎来到你的微店咖啡馆！\n奖励开店资金" + data.data + "金币！\n快去装修你的咖啡馆吧~"
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.startBtn, this.onTap_closeBtn);
        this.onTap(this.closeBtn, this.onTap_closeBtn);

    }
    onTap_closeBtn() {
        
        Waiting.instance.show()
        weidianNet.index(async(s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.scene.updateData();
            this.hidePanel();
        
            await Ani.instance.awardCoinAni(this.scene)

        }, window['projectxId'])
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.startBtn, this.onTap_closeBtn);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }



}