import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class GiftSuccessPanel extends Panel {
    protected get skinKey() { return 'pop/GiftSuccess' }
    public gsMercImg:eui.Image;
    public gsname:eui.Label;
    public buyBtn:eui.Button;
    public closeBtn:eui.Button;
    private func:any;
    private diamond:any;

    constructor(data){
        super();
        //let _data = data.data;
        this.initUI(data);
    }

    initUI(data){
        //let dataitem = {predia:,preflag:,preid:,preurl:};
        this.gsMercImg.source = data.data.preicon;
        this.gsname.text = data.data.prename;
        this.diamond = data.diamond;
        this.func = this.onTap_buyBtn.bind(this,data.data2.url);
        this.onTap(this.buyBtn,this.func);
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        
    }
    onTap_closeBtn(){
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            weidianNet.prize((s)=>{
                if(!s){
                    return
                }
                let data = { data: DataManager.ins.getData("exchangeList").data,data2:DataManager.ins.getData("prize").data, diamond: this.diamond, scene: this }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
            }, window['projectxId'],"");
            this.hidePanel()
        }, window['projectxId'])
    }
    onTap_buyBtn(url){
        //接口
        this.hidePanel();
        window.location.href = "weidianbuyer://wdb/webview?url=encodeURIComponent("+url+")";
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.buyBtn,this.onTap_buyBtn);
    }
}