import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import { DataManager } from "../../libs/tw/manager/DataManager";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
export default class GiftListPanel extends Panel {
    protected get skinKey() { return 'pop/GiftList' }
    public backBtn: eui.Button;
    public mercList: eui.Scroller;
    public mercGroup: eui.Group;

    private prefabPool: any[] = [];
    private funcPool: any[] = [];

    constructor(data) {
        super();
        let _data = data.data;
        this.initUI(_data);
    }
    initUI(data) {
        if (data.length > 0) {
            let count = 0;
            for (let i = 0; i < data.length; i++) {
                if (data[i].exchangeFlag) {
                    let prefab = this.createPrefab(data[i]);
                    prefab.x = 0
                    prefab.y = count * 213;
                    prefab.width = 705;
                    prefab.height = 213;
                    this.prefabPool.push(prefab);
                    this.mercGroup.addChild(prefab);
                    count += 1;
                }
            }

        }
        if (this.prefabPool.length > 0) {
            for (let n = 0; n < this.prefabPool.length; n++) {
                let func = this.onTap_glBtn.bind(this, this.prefabPool[n].id)
                this.funcPool.push(func);
                this.onTap(this.prefabPool[n]['glBtn'], this.funcPool[n])
            }
        }

    }
    initEvents() {
        super.initEvents();
        this.onTap(this.backBtn, this.onTap_backBtn);
    }

    createPrefab(data) {
        let prefab: any = new eui.Component();
        prefab.skinName = "GlOptionSkin";
        prefab['glImg'].source = data.extra.name;
        prefab['glLab'].text = data.extra.icon;
        // prefab['glBtn'].icon = "gifted_png"

        prefab.id = data.prizeId;
        // prefab.url = data.url;
        return prefab;
    }

    onTap_glBtn(id) {
        //this.hidePanel();
        Waiting.instance.show();
        weidianNet.getJumpUrl((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            let url = DataManager.ins.getData("getJumpUrl").data.url;
            window.location.href = "weidianbuyer://wdb/webview?url=encodeURIComponent("+url+")";
        }, id, window['projectxId'])

    }
    onTap_backBtn() {
        this.hidePanel();
    }
}