import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import GameConst from "../GameConst";
export default class FoodReadyPanel extends Panel {
    protected get skinKey() { return 'pop/FoodReady' }

    public frBtn: eui.Button;
    public closeBtn: eui.Button;
    public costLab: eui.Label;

    private func: any;
    private funcclose:any;
    private cost: any = 0;
    constructor(data) {
        super();
        // let _data = data//.data;
        this.initUI(data);
    }
    initUI(data) {
        this.cost = GameConst.tranNumber(data.data.needGold);
        this.costLab.text = "每抢到一单，消耗" + this.cost + "金币";
        let tapdata = { cost: data.data.needGold, coin: data.data.storeGoldCoin, scene: data.scene }
        this.func = this.onTap_frBtn.bind(this, tapdata);
        this.onTap(this.frBtn, this.func);
        if (data.data.needGold <= data.data.storeGoldCoin) {

        } else {
            this.setColor(this.frBtn);
            
        }
        this.funcclose = this.onTap_closeBtn.bind(this,data.scene);
        this.onTap(this.closeBtn, this.funcclose);
    }

    initEvents() {
        super.initEvents();
        
    }
    onTap_frBtn(data) {
        // this.hidePanel();
        if (data.cost <= data.coin) {
            Waiting.instance.show()
            weidianNet.getVie((s) => {
                Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("活动太火爆了，请稍后再来~")
                    return
                }
                PanelCtrl.instance.show(ModuleTypes.FOODGO_PANEL, data);
            }, window['projectxId'])
        } else {
            ToastCtrl.instance.show("金币不足，继续赚取更多金币吧~");
        }
    }
    onTap_closeBtn(scene) {
        weidianNet.index((s) => {
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            scene.updateData();
            this.hidePanel()
        }, window['projectxId'])
    }

    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.frBtn, this.func);
        this.clearTap(this.closeBtn, this.funcclose);
    }

}