import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import SVGACtrl from "../ctrls/svgaCtrl";
import { weidianNet } from "../NetConst";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
export default class FoodGoPanel extends Panel {
    protected get skinKey() { return 'pop/FoodGo' }
    public counttime: eui.Label;
    public getnum: eui.Label;
    public fgBtn: eui.Button;
    public closeBtn: eui.Button;
    public costLab: eui.Label

    public datacoin: number = 0;
    public datacost: number = 0;
    public clicks: number = 0;
    private nowtime: number = 0;

    private funcFrame:any;

    constructor(data) {
        super();
        this.initUI(data);
    }
    initUI(data) {

        this.datacoin = data.coin;
        this.datacost = data.cost;
        this.counttime.text = "00:10:00"
        this.nowtime = new Date().getTime() + 10000;
        this.costLab.text = "每抢到一单，消耗" + this.datacost + "金币";

        this.onTap(this.fgBtn, this.onTap_fgBtn);
        this.funcFrame = this.onEnterFrame.bind(this,data.scene);
        this.addEventListener(egret.Event.ENTER_FRAME, this.funcFrame, this);

    }
    initEvents() {
        super.initEvents();

        
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    onEnterFrame(scene) {

        //倒计时
        let now: number = new Date().getTime();
        let second: any = Math.floor((this.nowtime - now) / 1000);
        let millisecond: any = (this.nowtime - now) % 1000;
        let milli1: any = Math.floor(millisecond / 100);
        let milli2: any = Math.floor((millisecond - milli1 * 100) / 10)
        let milli3: any = (millisecond - milli1 * 100 - milli2 * 10)

        if (milli3 > 5) {
            milli2 += 1;
            if (milli2 == 10) {
                milli1 += 1;
                milli2 = 0;
                if (milli1 == 10) {
                    milli1 = 0;
                    second += 1;
                }
            }
        }

        this.counttime.text = "00:0" + second + ":" + milli1 + milli2;
        if (now >= this.nowtime) {
            this.counttime.text = "00:00:00"
            //Waiting.instance.show();
            weidianNet.postVie((s) => {
               // Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("活动太火爆了，请稍后再来~")
                    return
                }
                this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
                this.clearTap(this.fgBtn, this.onTap_fgBtn);
                this.hidePanel()
                //data:DataManager.ins.getData("postVie").data,
                let data = { coins: this.datacoin, data: DataManager.ins.getData("postVie").data, clicks: this.clicks, scene: scene };
                PanelCtrl.instance.show(ModuleTypes.FOODEND_PANEL, data);
            }, this.clicks, window['projectxId'])

        }
    }

    onTap_fgBtn() {

        let add = new eui.Image();
        add.source = "add_png";
        add.width = 124;
        add.height = 88;
        add.anchorOffsetX = 62;
        add.anchorOffsetY = 44;
        this.addChild(add);
        egret.Tween.get(add)
            .set({ x: 375, y: 600, rotation: -45 })
            .to({ y: 440, rotation: 0 }, 250)
            .to({ alpha: 0 })

        this.clicks += 1;

    }

    onTap_closeBtn() {
        this.hidePanel();
    }
    removeEvents() {
        super.removeEvents()
        this.removeEventListener(egret.Event.ENTER_FRAME, this.funcFrame, this);
    }
}