import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
export default class FoodEndPanel extends Panel {
    protected get skinKey() { return 'pop/FoodEnd' }
    public getnum:eui.Label;
    public closeBtn:eui.Button;
    public foodendBtn:eui.Button;
    private funcclose:any;
    private diamond:number;
    constructor(data){
        super();
        
        this.initUI(data);
    }
    initUI(data){
        
        this.getnum.text = "共抢到"+data.clicks+"个外卖订单！\n共收获"+data.data.getDiamond+"个     ！\n";  //data.data.getDiamond
        this.funcclose = this.onTap_closeBtn.bind(this, data.scene);
        this.diamond = data.data.storeDiamond;
        this.onTap(this.foodendBtn,this.funcclose);
        this.onTap(this.closeBtn,this.funcclose);
    }

    initEvents(){
        super.initEvents();
    }

    onTap_closeBtn(scene){
        Waiting.instance.show();
        weidianNet.index(async(s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel()
            await Ani.instance.awardDiamondAni(scene);
            scene.updateData();
            scene.updateVie();
            scene.updateDiamond(this.diamond);
            
        }, window['projectxId'])
        //接口
    }

    // onTap_endBtn(){

    // }

    removeEvents(){
        super.removeEvents();
        this.clearTap(this.foodendBtn,this.funcclose);
        this.clearTap(this.closeBtn,this.funcclose);
    }
}