import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import ToastCtrl from "../ctrls/toastCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { weidianNet } from "../NetConst";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
export default class ConvertPanel extends Panel {
    protected get skinKey() { return 'pop/Convert' }

    public closeBtn:eui.Button;
    public changeLab:eui.Label;
    public prizeimg:eui.Image;
    public prizeLab:eui.Label;
    public thinkBtn:eui.Button;
    public sureBtn:eui.Button;

    private diamond :any;
    public func:any;
    constructor(data){
        super();
        //let _data = data.data;
        this.diamond = data.diamond;
        this.initUI(data)
    }

    initUI(data){
        //let dataitem = {predia:,preflag:,preid:,preurl:};
        this.changeLab.text = "确定花    "+data.predia+"进行兑换吗？"
        this.prizeimg.source = data.preicon;
        this.prizeLab.text = data.prename;
        this.func = this.onTap_sureBtn.bind(this,data);
        this.onTap(this.sureBtn,this.func);
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.thinkBtn,this.onTap_closeBtn);
        
        
    }
    
    onTap_closeBtn(){
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            weidianNet.prize((s)=>{
                if(!s){
                    return
                }
                let data = { data: DataManager.ins.getData("exchangeList").data,data2:DataManager.ins.getData("prize").data, diamond: this.diamond, scene: this }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
            }, window['projectxId'],"");
            this.hidePanel()
        }, window['projectxId'])
        
    }
    onTap_sureBtn(data){
        //接口
        Waiting.instance.show();
        weidianNet.exchange((s)=>{
            Waiting.instance.hide();
            if(!s){
                if(DataManager.ins.getData("exchange").message){
                    ToastCtrl.instance.show(DataManager.ins.getData("exchange").message);
                }else{
                    ToastCtrl.instance.show("活动太火爆了，请稍后再来~");
                }
                return
            }
            ToastCtrl.instance.show("兑换成功，可于我的兑换中查看详情")
            this.hidePanel();
            let exchangedata = {data:data,data2:DataManager.ins.getData("exchange").data,diamond:this.diamond}
            PanelCtrl.instance.show(ModuleTypes.GIFTSUCCESS_PANEL,exchangedata);
        },data.preid,window['projectxId']);
        
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.thinkBtn,this.onTap_closeBtn);
        this.clearTap(this.sureBtn,this.func);
    }
}