import { GCache } from './../../libs/tc/util/GCache';
import { ModuleType } from './../../libs/tc/enum/ModuleType';
import { Buried } from './../../libs/tw/util/Buried';
import { NetManager } from './../../libs/tw/manager/NetManager';

import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { playBg } from './../ctrls/soundCtrl';
import { weidianNet } from './../NetConst';
import { wait } from './../GameConst';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import Ani from "./Ani";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import GameConst from "../GameConst";
import SVGACtrl from '../ctrls/svgaCtrl';
import Waiting from '../waiting/Waiting';
import ToastCtrl from '../ctrls/toastCtrl';
import SceneCtrl from '../ctrls/sceneCtrl';
import AddSpeedBtn from './AddSpeed';
// import BuiredCtrl from '../ctrls/BuiredCtrl';
import Panel from '../views/Panel';
import { equipmentConfig } from './EquipmentConfig';


export default class MainScene extends Scene {

    public get skinKey() { return "Main" }

    public bg: eui.Image;
    public diamondNum: eui.Component;
    public coinNum: eui.Component;
    public nickName: eui.Component;
    public barCounter: eui.Image;
    public barCounterCollectBtn: eui.Component;
    public refrigerator: eui.Image;
    public refrigeratorCollectBtn: eui.Component;
    public vase: eui.Image;
    public table0: eui.Image;
    public table1: eui.Image;
    public tableCollectBtn: eui.Component;
    public waitress0: eui.Group;
    public waitressCapacity: eui.Group;
    public waitressCapacityTxt: eui.Label;
    public waitress1: eui.Group;
    public table2: eui.Image;
    public table3: eui.Image;
    public coffeeMakerGroup: eui.Group;
    public coffeeMaker: eui.Image;
    public coffeeMakerCollectBtn: eui.Component;
    public ovenGroup: eui.Group;
    public oven: eui.Image;
    public ovenCollectBtn: eui.Component;
    public decorateBtn: eui.Button;
    public redPacketBtn: eui.Button;
    public exchangeBtn: eui.Button;
    public taskBtn: eui.Button;
    public doVieBtn: eui.Button;
    public vieTips: eui.Group;
    public vieTipsBg: eui.Image;
    public vieCountDown: eui.Label;
    public waitress: eui.Image;
    public friendsScoller: eui.Scroller;
    public friendsGroup: eui.Group;
    public inviteBtn: eui.Image;
    public payBtn: eui.Button;


    private addSpeedBtn: AddSpeedBtn;

    public waitress0Base: any;
    public waitress1Base: any;

    private mainConfig = {
        "hasStore": true,
        "username": "",
        "avatar": "",
        "storeLevel": 0,
        "coin": 0,
        "diamond": 0,
        "storeUpgrade": false,
        "hasUpgradeReward": false,
        "upgradeReward": 0,
        "chickenStatus": 0,
        "chickenNewEnable": false,
        "chickenEndTime": 1569825488,
        "hasChickenTime": 0,
        "feeStatus": 0,
        "feeNewEnable": false,
        "feeNextPayTime": 1569080288,
        "grabStatus": 0,
        "grabNewEnable": false,
        "grabNextTime": 1569080288,
        "waiterExtraGold": false,
        "table": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "barCounter": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "refrigerator": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "oven": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "coffeeMaker": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "waitress": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        }
    }

    constructor(data?) {
        super();
        this.percentHeight = 100;
        this.percentWidth = 100;

        this.firstVisit = data;

        // 初始化UI
        this.updateUI()
        // 初始化埋点
        this.initBuired();

        this.initLogic();

    }


    updateUI() {

        this.updateData()

        const shopsList = DataManager.ins.getData("getShopsInfo") && DataManager.ins.getData("getShopsInfo").data && DataManager.ins.getData("getShopsInfo").data.shops ? DataManager.ins.getData("getShopsInfo").data.shops : [];
        const friendsList = DataManager.ins.getData("getFriendsInfo") && DataManager.ins.getData("getFriendsInfo").data && DataManager.ins.getData("getFriendsInfo").data.friends ? DataManager.ins.getData("getFriendsInfo").data.friends : [];

        this.nickName['avatar'].source = this.mainConfig.avatar;


        let i = 0;
        if (shopsList.length > 0) {
            shopsList.forEach(shopItem => {
                let shop = new eui.Component();
                shop.skinName = "FriendItemSkin"
                shop.x = i * 120;
                shop.y = 5;
                shop['avatar'].source = shopItem.shopLogo;
                shop['avatar'].mask = shop['avatarMask'];
                shop['nameTxt'].text = this.fixName(shopItem.shopName);
                shop['shopId'] = shopItem.shopId;
                this.friendsGroup.addChild(shop);
                this.onTap(shop, this.onTap_shop);
                i++;
            });

        }

        if (friendsList.length > 0) {
            friendsList.forEach(friendItem => {
                let friend = new eui.Component();
                friend.skinName = "FriendItemSkin"
                friend.x = i * 120;
                friend.y = 5;
                friend['avatar'].source = friendItem.avatar;
                friend['avatar'].mask = friend['avatarMask'];
                friend['nameTxt'].text = this.fixName(friendItem.nickname);
                friend['friendUserId'] = friendItem.friendUserId;
                this.friendsGroup.addChild(friend);
                this.onTap(friend, this.onTap_friend)
                i++;
            });
        }


        this.inviteBtn.x = i * 120;

        this.nickName['usernametxt'].text = this.mainConfig.username + "的咖啡屋"
        this.nickName['levelTxt'].text = "Lv" + this.mainConfig.storeLevel + ""
        this.coinNum['coinNumTxt'].text = GameConst.tranNumber(Number(this.mainConfig.coin + ""), 1);
        this.diamondNum['diamondNumTxt'].text = GameConst.tranNumber(Number(this.mainConfig.diamond + ""), 1);

        if (Number(this.mainConfig.table.level) > 0) {
            for (let i = 0; i < 4; i++) {
                this['table' + i].visible = true;
                this['table' + i].scaleX = 1;
                this['table' + i].scaleY = 1;
                this['table' + i].source = `table${i}${this.mainConfig.table.level}_png`;
            }
            if (this.mainConfig.table.capacity > 0) {
                this.updateCapacity("table");
            }
        }

        if (Number(this.mainConfig.oven.level) > 0) {
            this.ovenGroup.visible = true;
            this.ovenGroup.scaleX = 1;
            this.ovenGroup.scaleY = 1;
            this.oven.source = `ovenLv${this.mainConfig.oven.level}_png`;
            this.oven.anchorOffsetX = equipmentConfig.oven[`lv${this.mainConfig.oven.level}`].anchorOffsetX;
            this.oven.anchorOffsetY = equipmentConfig.oven[`lv${this.mainConfig.oven.level}`].anchorOffsetY;
            if (this.mainConfig.oven.capacity > 0) {
                this.updateCapacity("oven");
            }
        }

        if (Number(this.mainConfig.refrigerator.level) > 0) {
            this.refrigerator.visible = true;
            this.refrigerator.scaleX = 1;
            this.refrigerator.scaleY = 1;
            this.refrigerator.source = `refrigeratorLv${this.mainConfig.refrigerator.level}_png`
            this.refrigerator.anchorOffsetX = equipmentConfig.refrigerator[`lv${this.mainConfig.refrigerator.level}`].anchorOffsetX;
            this.refrigerator.anchorOffsetY = equipmentConfig.refrigerator[`lv${this.mainConfig.refrigerator.level}`].anchorOffsetY;
            if (this.mainConfig.refrigerator.capacity > 0) {
                this.updateCapacity("refrigerator");
            }
        }

        if (Number(this.mainConfig.coffeeMaker.level) > 0) {
            this.coffeeMakerGroup.visible = true;
            this.coffeeMakerGroup.scaleX = 1;
            this.coffeeMakerGroup.scaleY = 1;
            this.coffeeMaker.source = `coffeeMakerLv${this.mainConfig.coffeeMaker.level}_png`;
            this.coffeeMaker.anchorOffsetX = equipmentConfig.coffeeMaker[`lv${this.mainConfig.coffeeMaker.level}`].anchorOffsetX;
            this.coffeeMaker.anchorOffsetY = equipmentConfig.coffeeMaker[`lv${this.mainConfig.coffeeMaker.level}`].anchorOffsetY;
            if (this.mainConfig.coffeeMaker.capacity > 0) {
                this.updateCapacity("coffeeMaker");
            }
        }

        if (Number(this.mainConfig.barCounter.level) > 0) {
            this.barCounter.visible = true;
            this.barCounter.scaleX = 1;
            this.barCounter.scaleY = 1;
            this.barCounter.source = `barCounterLv${this.mainConfig.barCounter.level}_png`
            this.barCounter.anchorOffsetX = equipmentConfig.barCounter[`lv${this.mainConfig.barCounter.level}`].anchorOffsetX;
            this.barCounter.anchorOffsetY = equipmentConfig.barCounter[`lv${this.mainConfig.barCounter.level}`].anchorOffsetY;
            if (this.mainConfig.barCounter.capacity > 0) {
                this.updateCapacity("barCounter");
            }
        }

        if (this.mainConfig.waitress.level > 0) {
            for (let i = 0; i < 2; i++) {
                let waitress = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.SVGAPool[`waitressLv${this.mainConfig.waitress.level}`]);
                waitress.x = 50;
                waitress.y = 180;
                waitress.anchorOffsetX = 50;
                waitress.anchorOffsetY = 180;

                waitress.scaleX = -1 * Math.pow(-1, i);
                this[`waitress${i}Base`] = waitress;
                this['waitress' + i].scaleX = 1;
                this['waitress' + i].scaleY = 1;
                this['waitress' + i].addChild(waitress);
                this['waitress' + i].dir = -1 * Math.pow(-1, i);
            }
            if (this.mainConfig.waitress.capacity > 0) {
                this.updateCapacity("waitress", 3000);
            }
            this.randomMove();
        }

        this.updateAddSpeed();

        if (this.mainConfig.feeNewEnable) {
            // 是否新开放缴费功能

        }

        /**
         * 	0没有该功能	1待缴费 2已缴费
         */
        switch (this.mainConfig.feeStatus + "") {
            case "0":
                this.payBtn.visible = false;
                break;
            case "1":
                this.payBtn.visible = true;
                break;
            case "2":
                this.payBtn.visible = false;
                break;
        }

        this.updateVie();

        if (this.mainConfig.storeUpgrade) {
            // 店铺升级
        }

    }



    isShowVieCountDown: boolean = false;
    updateVie() {
        if (this.mainConfig.grabNewEnable) {
            // 是否新开放抢单功能
        }

        switch (this.mainConfig.grabStatus + "") {
            case "0":
                // 没有该功能
                this.doVieBtn.visible = false;
                this.vieTips.visible = false;
                break;
            case "1":
                // 可抢单
                this.vieTips.visible = false;
                break;
            case "2":
                // 不可抢单  展示下次抢单时间
                this.vieTips.visible = true;

                this.isShowVieCountDown = true;
                // 按钮置灰
                GameConst.setGray(this.doVieBtn);
                this.doVieBtn.visible = true;
                this.doVieBtn.touchChildren = false;
                this.doVieBtn.touchEnabled = false;
                break;
        }
    }
    /**
     * 更新数据
     */
    updateData() {
        const { hasStore, nickName, avatar, goldCoin, diamond, storeLevel, equipmentList, storeUpgrade, hasUpgradeReward, upgradeReward,
            chickenStatus, chickenNewEnable, hasChickenTime, chickenEndTime, feeStatus, feeNextPayTime, grabStatus, grabNextTime, waiterExtraGold } = DataManager.ins.getData("index").data;

        this.mainConfig.hasStore = hasStore;
        this.mainConfig.username = nickName;
        this.mainConfig.avatar = avatar;
        this.mainConfig.storeLevel = storeLevel;
        this.mainConfig.coin = goldCoin;
        this.mainConfig.diamond = diamond;
        this.mainConfig.storeUpgrade = storeUpgrade;
        this.mainConfig.hasUpgradeReward = hasUpgradeReward;
        this.mainConfig.upgradeReward = upgradeReward;
        this.mainConfig.chickenStatus = chickenStatus;
        this.mainConfig.chickenNewEnable = chickenNewEnable;
        this.mainConfig.chickenEndTime = chickenEndTime;
        this.mainConfig.hasChickenTime = hasChickenTime;
        this.mainConfig.feeStatus = feeStatus;
        this.mainConfig.feeNextPayTime = feeNextPayTime;
        this.mainConfig.grabStatus = grabStatus;
        this.mainConfig.grabNextTime = grabNextTime;
        this.mainConfig.waiterExtraGold = waiterExtraGold;
        //1桌椅 2烤箱 3冰柜 4咖啡机 5收银台 6服务员
        if (equipmentList && equipmentList.length > 0) {
            equipmentList.forEach(equipment => {
                switch (equipment.type + "") {
                    case "1":
                        // 桌椅
                        this.mainConfig.table.capacity = equipment.capacity;
                        this.mainConfig.table.level = equipment.level;
                        this.mainConfig.table.store = equipment.canReceiveGold;
                        this.mainConfig.table.type = equipment.type;
                        break;
                    case "2":
                        // 烤箱
                        this.mainConfig.oven.capacity = equipment.capacity;
                        this.mainConfig.oven.level = equipment.level;
                        this.mainConfig.oven.store = equipment.canReceiveGold;
                        this.mainConfig.oven.type = equipment.type;
                        break;
                    case "3":
                        // 冰柜
                        this.mainConfig.refrigerator.capacity = equipment.capacity;
                        this.mainConfig.refrigerator.level = equipment.level;
                        this.mainConfig.refrigerator.store = equipment.canReceiveGold;
                        this.mainConfig.refrigerator.type = equipment.type;
                        break;
                    case "4":
                        // 咖啡机
                        this.mainConfig.coffeeMaker.capacity = equipment.capacity;
                        this.mainConfig.coffeeMaker.level = equipment.level;
                        this.mainConfig.coffeeMaker.store = equipment.canReceiveGold;
                        this.mainConfig.coffeeMaker.type = equipment.type;
                        break;
                    case "5":
                        // 收银台
                        this.mainConfig.barCounter.capacity = equipment.capacity;
                        this.mainConfig.barCounter.level = equipment.level;
                        this.mainConfig.barCounter.store = equipment.canReceiveGold;
                        this.mainConfig.barCounter.type = equipment.type;
                        break;
                    case "6":
                        // 服务员
                        this.mainConfig.waitress.capacity = equipment.capacity;
                        this.mainConfig.waitress.level = equipment.level;
                        this.mainConfig.waitress.store = equipment.canReceiveGold;
                        this.mainConfig.waitress.type = equipment.type;
                        break;
                }
            });
        }

        this.updateCoin(this.mainConfig.coin);
        this.updateDiamond(this.mainConfig.diamond);
    }

    /**
     * 转换产能  从以天为维度转换为以小时、分钟、秒为维度
     * @param capacity 产能
     * @param type 转换类型
     */
    exchangeCapacity(capacity, type = "s", isFloor = true) {
        let result = 0;
        switch (type) {
            case "h":
                result = isFloor ? Math.floor(capacity / 24) : capacity / 24;
                break;
            case "m":
                result = isFloor ? Math.floor(capacity / 24 / 60) : capacity / 24 / 60;
                break;
            case "s":
                result = isFloor ? Math.floor(capacity / 24 / 60 / 60) : capacity / 24 / 60 / 60;
                break;
        }
        return result;
    }

    updateCoin(goldCoin) {
        this.coinNum['coinNumTxt'].text = GameConst.tranNumber(Number(goldCoin + ""), 1);
    }

    updateDiamond(diamond) {
        this.diamondNum['diamondNumTxt'].text = GameConst.tranNumber(Number(diamond + ""), 1);
    }

    initBuired() {

    }

    firstVisit = false;
    isGuide = false;
    initLogic() {
        // 是否首次进入
        const { sign } = DataManager.ins.getData("getTaskInfo").data;
        if (this.firstVisit) {
            // 首次访问 首次开店弹窗 然后新手引导
            PanelCtrl.instance.show(ModuleTypes.GUIDENEW_PANEL)
            this.isGuide = true;
        } else {
            // 非首次访问

            // 是否每日首次访问
            if (GCache.readCache(new Date(new Date().toLocaleDateString()).getTime() + "")) {
                // 非每日首次访问

            } else {
                // 每日首次访问
                GCache.writeCache(new Date(new Date().toLocaleDateString()).getTime() + "", 1)
                if (sign) {
                    // 今日已经签过到 无操作
                    // if(){

                    // }
                } else {
                    // 今日未签到  进行签到
                    let data = { data: DataManager.ins.getData("getTaskInfo").data, scene: this }
                    PanelCtrl.instance.show(ModuleTypes.SIGN_PANEL, data);
                }
            }

        }


    }

    initEvents() {
        super.initEvents();
        this.onTap(this.taskBtn, this.onTap_taskBtn);
        this.onTap(this.decorateBtn, this.onTap_decorateBtn);
        this.onTap(this.exchangeBtn, this.onTap_exchangeBtn);
        this.onTap(this.inviteBtn, this.onTap_inviteBtn);
        this.onTap(this.payBtn, this.onTap_payBtn);
        this.onTap(this.doVieBtn, this.onTap_doVieBtn);

        this.onTap(this.refrigeratorCollectBtn, this.onTap_refrigeratorCollectBtn);
        this.onTap(this.barCounterCollectBtn, this.onTap_barCounterCollectBtn);
        this.onTap(this.tableCollectBtn, this.onTap_tableCollectBtn);
        this.onTap(this.ovenCollectBtn, this.onTap_ovenCollectBtn);
        this.onTap(this.coffeeMakerCollectBtn, this.onTap_coffeeMakerCollectBtn);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);

        GDispatcher.addEvent("startAddSpeed", this.startAddSpeed, this);

    }

    startAddSpeed() {
        console.log("开始加速")
        // 开始倒计时
        // let timer = new Timer();
        this.randomMove(5);
        this.mainConfig.waitress.capacity = this.mainConfig.waitress.capacity * 1.5;
        this.updateCapacity("waitress", 1500)
        wait(1000 * 60 * 10).then(() => {
            weidianNet.index((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新打鸡血失败，请刷新重试~")
                    return
                }
                this.updateData();
                this.updateAddSpeed();
            }, window['projectxId'])
        })
    }
    // 更新打鸡血按钮状态
    updateAddSpeed() {
        if (this.mainConfig.chickenNewEnable) {
            // 是否新开放打鸡血功能
        }

        switch (this.mainConfig.chickenStatus + "") {
            case "0":
                // 没有该功能
                break;
            case "1":
                // 可以打鸡血
                this.addSpeedBtn = new AddSpeedBtn();
                this.addSpeedBtn.bottom = 162;
                this.addSpeedBtn.anchorOffsetX = 98 / 2;
                this.addSpeedBtn.anchorOffsetY = 98 / 2;
                this.addSpeedBtn.x = 660;
                this.addSpeedBtn.width = 98;
                this.addSpeedBtn.height = 98;
                this.addChild(this.addSpeedBtn)
                break;
            case "2":
                // 正在打鸡血
                this.addSpeedBtn = new AddSpeedBtn();
                this.addSpeedBtn.bottom = 162;
                this.addSpeedBtn.anchorOffsetX = 98 / 2;
                this.addSpeedBtn.anchorOffsetY = 98 / 2;
                this.addSpeedBtn.x = 660;
                this.addSpeedBtn.width = 98;
                this.addSpeedBtn.height = 98;
                this.addChild(this.addSpeedBtn)
                GameConst.setGray(this.addSpeedBtn);
                this.addSpeedBtn.touchEnabled = false;
                this.addSpeedBtn.touchChildren = false;
                // 计时
                break;
            case "3":
                // 次数已用完 不可打鸡血
                this.addSpeedBtn = new AddSpeedBtn();
                this.addSpeedBtn.bottom = 162;
                this.addSpeedBtn.anchorOffsetX = 98 / 2;
                this.addSpeedBtn.anchorOffsetY = 98 / 2;
                this.addSpeedBtn.x = 660;
                this.addSpeedBtn.width = 98;
                this.addSpeedBtn.height = 98;
                this.addChild(this.addSpeedBtn)
                GameConst.setGray(this.addSpeedBtn);
                this.addSpeedBtn.touchEnabled = false;
                this.addSpeedBtn.touchChildren = false;
                break;
        }
    }

    onTap_friend(e) {
        Waiting.instance.show();
        let friendUserId = e.$target.$parent.friendUserId;
        weidianNet.getFriendDetail((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开了点小差，请稍后再试~")
                return
            }
            SceneCtrl.instance.change(ModuleTypes.MINOR_SCENE, friendUserId);
        }, friendUserId, window['projectxId'])
    }

    onTap_shop(e) {
        Waiting.instance.show();
        let shopId = e.$target.$parent.shopId;
        weidianNet.getShopDetail((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("网络开了点小差，请稍后再试~")
                return
            }
            weidianNet.getShopStatus((ss) => {
                Waiting.instance.hide();
                SceneCtrl.instance.change(ModuleTypes.SHOP_SCENE);
            }, shopId, window['projectxId'])
        }, shopId, window["projectxId"])
    }

    onTap_payBtn() {
        Waiting.instance.show();
        weidianNet.getPayCount((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开了点小差，请稍后重试~")
                return
            }
            let data = {
                data: DataManager.ins.getData("getPayCount").data, goldCoin: DataManager.ins.getData("index").data.goldCoin, scene: this, func: () => {
                    this.payBtn.visible = false;
                }
            }
            PanelCtrl.instance.show(ModuleTypes.PAY_PANEL, data)
        }, window['projectxId'])
    }

    onTap_doVieBtn() {
        Waiting.instance.show();
        weidianNet.getVieCost((s) => {
            if (!s) {
                ToastCtrl.instance.show("网络开了小差，请重试~")
                return
            }
            this.updateData();
            let data = { data:DataManager.ins.getData("getVieCost").data, scene: this }
            PanelCtrl.instance.show(ModuleTypes.FOODREADY_PANEL, data);
        }, window["projectxId"])
    }

    onEnterFrame() {
        // 是否计算抢单倒计时
        if (this.isShowVieCountDown) {
            this.startCountDown(this.vieCountDown, this.mainConfig.grabNextTime, () => {
                this.vieTips.visible = false;
                this.doVieBtn.visible = true;
                GameConst.clearFilter(this.doVieBtn);
                this.isShowVieCountDown = false;
                this.doVieBtn.touchEnabled = true;
                this.doVieBtn.touchChildren = true;
            })
        }

    }

    onTap_refrigeratorCollectBtn() {
        Waiting.instance.show();
        this.refrigeratorCollectBtn.touchEnabled = false;
        this.refrigeratorCollectBtn.touchChildren = false;
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.refrigeratorCollectBtn.touchEnabled = true;
                this.refrigeratorCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(95, 155, this.refrigeratorCollectBtn, this);
            this.refrigeratorCollectBtn.touchEnabled = true;
            this.refrigeratorCollectBtn.touchChildren = true;
            this.mainConfig.refrigerator.store = 0;
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.refrigerator.type)
    }

    onTap_barCounterCollectBtn() {
        Waiting.instance.show();
        this.barCounterCollectBtn.touchEnabled = false;
        this.barCounterCollectBtn.touchChildren = false;
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.barCounterCollectBtn.touchEnabled = true;
                this.barCounterCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(538, 200, this.barCounterCollectBtn, this);
            this.barCounterCollectBtn.touchEnabled = true;
            this.barCounterCollectBtn.touchChildren = true;
            this.mainConfig.barCounter.store = 0;
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.barCounter.type)
    }

    onTap_tableCollectBtn() {
        Waiting.instance.show();
        this.tableCollectBtn.touchEnabled = false;
        this.tableCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.tableCollectBtn.touchEnabled = true;
                this.tableCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(560, 380, this.tableCollectBtn, this);
            this.tableCollectBtn.touchEnabled = true;
            this.tableCollectBtn.touchChildren = true;
            this.mainConfig.table.store = 0;
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.table.type)
    }

    onTap_ovenCollectBtn() {
        Waiting.instance.show();
        this.ovenCollectBtn.touchEnabled = false;
        this.ovenCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.ovenCollectBtn.touchEnabled = true;
                this.ovenCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(480, 750, this.ovenCollectBtn, this);
            this.ovenCollectBtn.touchEnabled = true;
            this.ovenCollectBtn.touchChildren = true;
            this.mainConfig.oven.store = 0;
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.oven.type)
    }

    onTap_coffeeMakerCollectBtn() {
        Waiting.instance.show();
        this.coffeeMakerCollectBtn.touchEnabled = false;
        this.coffeeMakerCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.coffeeMakerCollectBtn.touchEnabled = true;
                this.coffeeMakerCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(100, 750, this.coffeeMakerCollectBtn, this);
            this.coffeeMakerCollectBtn.touchEnabled = true;
            this.coffeeMakerCollectBtn.touchChildren = true;
            this.mainConfig.coffeeMaker.store = 0;
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.coffeeMaker.type)
    }

    // 邀请好友
    onTap_inviteBtn() {
        let data = { scene: this }
        PanelCtrl.instance.show(ModuleTypes.INVITE_PANEL, data)
    }

    // 店长任务
    async onTap_taskBtn() {
        Waiting.instance.show();
        weidianNet.getTaskInfo((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新任务失败，请重试~")
                return
            }
            let data = { data: DataManager.ins.getData("getTaskInfo").data, scene: this }
            PanelCtrl.instance.slideUp(ModuleTypes.TASK_PANEL, GameConst.stage.stageHeight * 2 / 5, data);
        }, window['projectxId'])
        // let data = {storeLevel:30,goldCoin:50000}
        // PanelCtrl.instance.show(ModuleTypes.FOODREADY_PANEL,data);

    }

    // 店铺装修
    async onTap_decorateBtn() {
        Waiting.instance.show();
        weidianNet.getEquipments((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新列表失败，请重试~")
                return
            }
            let data = {
                data: DataManager.ins.getData("getEquipments").data,
                coin: this.mainConfig.coin,
                scene: this,
                func: () => { }
            }
            PanelCtrl.instance.slideUp(
                ModuleTypes.GUIDEBUY_PANEL,
                GameConst.stage.stageHeight * 2 / 5,
                data
            )
        }, window["projectxId"])
    }

    // 兑换好礼
    async onTap_exchangeBtn() {
        this.exchangeBtn.touchEnabled = false;
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            this.exchangeBtn.touchEnabled = true;
            if (!s) {
                ToastCtrl.instance.show("网络开了小差，请重试~")
                return
            }
            weidianNet.prize((s)=>{
                if(!s){
                    return
                }
                let data = { data: DataManager.ins.getData("exchangeList").data,data2:DataManager.ins.getData("prize").data, diamond: this.mainConfig.diamond, scene: this }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
            }, window['projectxId'],"");
            
        }, window['projectxId'])

    }


    removeEvents() {
        super.removeEvents();
        this.clearTap(this.taskBtn, this.onTap_taskBtn);
        this.clearTap(this.decorateBtn, this.onTap_decorateBtn);
        this.clearTap(this.exchangeBtn, this.onTap_exchangeBtn);


        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }


    /**
         * 更新产能，默认5s更新一次
         * @param name 设备名字
         * @param time 更新间隔
         */
    updateCapacity(name: string, time = 5000) {

        if (name == "waitress") {
            let capacity = Math.floor(this.exchangeCapacity(this.mainConfig[name].capacity, "s", false) * time / 1000);
            wait(time).then(async () => {
                this.waitressCapacityTxt.text = "+" + GameConst.tranNumber(capacity);
                let ty = this.waitressCapacity.y;
                egret.Tween.removeTweens(this.waitressCapacity)
                egret.Tween.get(this.waitressCapacity)
                    .to({ alpha: 1 }, 330)
                    .wait(200)
                    .to({ y: ty - 10, alpha: 0 }, 330)
                    .call(() => {
                        this.waitressCapacity.y = ty;
                        this.mainConfig.coin += capacity;
                        this.updateCoin(this.mainConfig.coin)
                        this.updateCapacity(name, time);
                    })
            })
            return
        }
        // 取到目标产值 5秒的产值

        let capacity = Math.floor(this.exchangeCapacity(this.mainConfig[name].capacity, "s", false) * time / 1000);
        if (capacity < 1) {
            // 目标产值小于1 则取每分钟产值
            capacity = this.exchangeCapacity(this.mainConfig[name].capacity, "m")
            //????
            time = 60 * 1000
        }
        let collectBtn = this[`${name}CollectBtn`];
        // debugger
        if (collectBtn.scaleX == 0 && collectBtn.scaleY == 0) {
            // 如果按钮处于消失状态 展示按钮    
            wait(time).then(async () => {
                this.mainConfig[name].store += capacity;
                collectBtn.collectNumTxt.text = "+" + GameConst.tranNumber(this.mainConfig[name].store);
                collectBtn.touchEnabled = false;
                if (name != "barCounter") {
                    if (name == "table") {
                        Ani.instance.updateCoinBase(this[`${name}1`])
                    }
                    Ani.instance.updateCoinBase(this[`${name}`])
                }
                await Ani.instance.createCoinTips(collectBtn);
                collectBtn.touchEnabled = true;
                this.updateCapacity(name, time);
            })
        } else {
            // 如果按钮未收取 更新数字
            wait(time).then(async () => {
                this.mainConfig[name].store += capacity;
                collectBtn.collectNumTxt.text = "+" + GameConst.tranNumber(this.mainConfig[name].store);
                collectBtn.touchEnabled = false;
                if (name != "barCounter") {
                    if (name == "table") {
                        Ani.instance.updateCoinBase(this[`${name}1`])
                    }
                    Ani.instance.updateCoinBase(this[`${name}`])
                }
                await Ani.instance.updateCoinTips(collectBtn.collectNumTxt, this.mainConfig[name].store);
                collectBtn.touchEnabled = true;
                this.updateCapacity(name, time)
            })
        }

    }

    // 随机走动
    randomMove(rate: number = 40) {
        if (this.mainConfig.waitress.level > 0) {
            for (let i = 0; i < 2; i++) {
                let x = Math.max(310 + Math.random() * 5, Math.random() * 463)
                let y = Math.max(500, Math.random() * 950)
                let distance = GameConst.distance(this[`waitress${i}`], { x: x, y: y })

                if (x > this[`waitress${i}`].x) {
                    this[`waitress${i}Base`].scaleX = 1
                } else if (x < this[`waitress${i}`].x) {
                    this[`waitress${i}Base`].scaleX = -1
                }
                egret.Tween.removeTweens(this[`waitress${i}`]);
                egret.Tween.get(this[`waitress${i}`], { onChange: this.onMove.bind(this) })
                    .to({ x: x, y: y }, rate * distance)
                    .call(() => {
                        this.randomMove(rate)
                    })
            }
        }
    }

    onMove() {
        if (this.waitress1.y > this.waitress0.y) {
            this.addChildAt(this.waitress1, 16)
        } else if (this.waitress1.y < this.waitress0.y) {
            this.addChildAt(this.waitress0, 16)
        }
    }

    fixName(name, num = 4) {
        let nameArr = name.split("");
        if (nameArr.length < num) {
            return name;
        } else {
            let _name = ""
            for (let i = 0; i < num; i++) {
                _name += nameArr[i];
            }
            _name += "..."
            return _name;
        }

    }


    /**
     * 开始显示倒计时
     * @param target 显示目标
     * @param endTime 结束时间
     * @param callback 回调函数
     */
    startCountDown(target: eui.Label, endTime: number, callback: Function) {
        let now = new Date().getTime();
        if (now > endTime) {
            target.text = "00:00:00"
            return
        }
        let date: any = GameConst.time.getEndTime(endTime);
        target.text = `${date.h < 10 ? "0" + date.h : date.h}:${date.m < 10 ? "0" + date.m : date.m}:${date.s < 10 ? "0" + date.s : date.s}`
        if (date.h == 0 && date.m == 0 && date.s == 0) {
            callback()
        }
    }

}



