import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { weidianNet } from './../NetConst';
import ToastCtrl from '../ctrls/toastCtrl';
import GameConst from '../GameConst';

export default class AddSpeedBtn extends eui.Component {

    constructor() {
        super()


        this.init()
    }

    init() {

        this.skinName = "AddSpeedSkin";
        this["addSpeedBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addSpeedBtn, this);
        this.width = 98;
        this.height = 98;
    }

    /**
     * 更新状态
     */
    private Shape: egret.Shape = new egret.Shape();
    update(endAngle) {
        let center = { x: 98 / 2, y: 98 / 2 };
        this.Shape.graphics.clear();
        this.Shape.graphics.beginFill(0xffdb46);
        this.Shape.graphics.moveTo(center.x, center.y);
        this.Shape.graphics.lineTo(98 / 2, 2);
        this.Shape.graphics.drawArc(center.x, center.y, 98 / 2 - 3, -Math.PI / 2, -Math.PI / 2 + endAngle * Math.PI / 180);
        this.Shape.graphics.lineTo(center.x, center.y);
        this.Shape.graphics.endFill();
        this.addChildAt(this.Shape, 2);
    }

    private endAngle: number = 10;
    onTap_addSpeedBtn() {
        console.log(this.endAngle);

        let colorGrayMatrix = [
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0, 0, 0, 1, 0
        ];
        // if (this.endAngle == 370) {
        //     this.endAngle = 0
        // }
        this.update(this.endAngle);
        this.endAngle += 10;

        if (this.endAngle == 360) {
            this['addSpeedBtn'].touchEnabled = false;

            weidianNet.addSpeed(
                (s) => {
                    let data = { angle: this.endAngle }
                    if (!s) {
                        egret.Tween.get(data, { onChange: () => { this.update(data.angle) } })
                            .to({ angle: 0 }, 1000, egret.Ease.cubicIn)
                            .call(() => {
                                this['addSpeedBtn'].touchEnabled = true;
                                this.endAngle = 0;
                            })
                        ToastCtrl.instance.show("网络开了会小差，请稍后再试~")
                        return
                    }
                    egret.Tween.get(data, { onChange: () => { this.update(data.angle) } })
                        .to({ angle: 0 }, 1000, egret.Ease.cubicIn)
                        .call(() => {
                            GameConst.setGray(this['addSpeedBtn'])
                            this.endAngle = 0;
                            GDispatcher.dispatchEvent("startAddSpeed");
                        })
                },
                window['projectxId']
            )
        }
    }


}