import { ResGroupNameArr } from './../Main';
import { weidianNet } from './../NetConst';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { Buried } from './../../libs/tw/util/Buried';
import Scene from "../views/Scene";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from '../ctrls/sceneCtrl';
import GameConst from '../GameConst';
// import BridgeFactory from "../../libs/JSBridge/bridge/BridgeFactory";

import ProgressBar from "./ProgressBar";
import PanelCtrl from '../ctrls/panelCtrl';
import ToastCtrl from '../ctrls/toastCtrl';
export default class LoadingScene extends Scene {
    get skinKey() { return 'Loading' }

    public bg: eui.Image;
    public loadingBar;

    public loading: egret.tween.TweenGroup;
    public isNormalLoaded: boolean = false;
    public isVideoCanPlay: boolean = false;
    public isAniEnd: boolean = false;
    public loadingExposure: any;
    public checkInterval: any;

    public targetValue: number = 0;

    start() {
        egret.Tween.removeAllTweens();

        this.percentWidth = 100;
        this.percentHeight = 100;

        // 初始化埋点信息
        this.initBuired();

        this.checkAllResLoaded();
    }

    // 初始化埋点信息
    initBuired() {
        const dpm = Buried.connectDpm(40, 1, 1);
        const dcm = Buried.connectDcm(230, window['skinID'], 0);
        this.loadingExposure = Buried.createExposure(dpm, dcm);

        //发送曝光埋点
        NetManager.ins.showLog(this.loadingExposure);
    }


    // 侦听事件
    initEvents() {
        RES.addEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
    }

    removeEvents() {
        RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
    }

    // preload资源组加载进度
    async onResourceProgress(event: RES.ResourceEvent) {
        for (let i = 2; i < ResGroupNameArr.length; i++) {
            if (event.groupName == ResGroupNameArr[i]) {
                if (event.groupName == ResGroupNameArr[ResGroupNameArr.length - 1]) {
                    if (event.itemsLoaded == event.itemsTotal) {
                        window['allLoaded'] = true;
                    }
                }

                this[`${ResGroupNameArr[i]}Precent`] = Math.round(event.itemsLoaded / event.itemsTotal * 100)
                this.log("loading:" + this[`${ResGroupNameArr[i]}Precent`] + "%")
                if (this.loadingBar) {
                    egret.Tween.removeTweens(this.loadingBar)
                    this.processAni(this[`${ResGroupNameArr[i]}Precent`]);
                }
            }
        }

        this.checkAllResLoaded();
    }

    processAni(targetValue) {
        return new Promise(r => {
            egret.Tween.get(this.loadingBar)
                .to({ value: targetValue }, 330)
                .call(() => {
                    r();
                })
        })
    }

    checkAllResLoaded() {
        if (window['allLoaded']) {
            if (this.loadingBar.value < 100) {
                // 进度条未满100走到100再进行下一步
                egret.Tween.removeTweens(this.loadingBar)
                let loadingTW = egret.Tween.get(this.loadingBar);
                loadingTW.to({ value: 100 }, 1000).call(() => {
                    this.handleLoaded();
                });
            } else {
                // 进度条已达到100 进入下一步
                this.handleLoaded();
            }
        }

    }

    //加载成功后操作
    handleLoaded() {
        // 判断是否新用户
        weidianNet.index((s) => {
            if (!s) {
                PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络异常，请刷新重试~", type: "reload" })
                return
            }
            weidianNet.getTaskInfo((ss) => {
                if (!ss) {
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络异常，请刷新重试~", type: "reload" })
                    return
                }
                const { hasStore } = DataManager.ins.getData("index").data;
                if (hasStore) {
                    weidianNet.getShopsInfo((sss) => {
                        if (!sss) {
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络异常，请刷新重试~", type: "reload" })
                            return
                        }
                        weidianNet.getFriendsInfo((ssss) => {
                            if (!ssss) {
                                ToastCtrl.instance.show("啊哦，获取好友列表失败~")
                                return
                            }
                            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
                        }, window['projectxId'])
                    }, window['projectxId'])
                } else {
                    SceneCtrl.instance.change(ModuleTypes.BEGIN_SCENE)
                }

            }, window['projectxId'])

        }, window['projectxId'])


    }

    // onLoadingChange() {
    //     if (this && this.loadingBar && this.loadingBar['progressNum']) {
    //         this.loadingBar['progressNum'].text = `加载中  ${Math.ceil(this.loadingBar.value)}%`;
    //     }
    // }

}
