import { GTime } from './../../libs/tc/util/GTime';
import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Msg from "../alert/Msg";
import Waiting from "../waiting/Waiting";
import Toast from '../views/Toast';
export default class ToastCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Sprite;
    static _instance: ToastCtrl;
    /**
     * 实例
     */
    static get instance() {
        return ToastCtrl._instance || (ToastCtrl._instance = new ToastCtrl())
    }

    /**
     * 初始化
     * @param parent 赋值父级 
     */
    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    /**
     * 显示
     * @param data 信息
     * @param time 持续时间
     */
    show(data, time = 1500) {
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current)
        } else {

        }
        const cls = this._toastClassMap[ModuleTypes.TOAST];
        const Toast: Panel = new cls(data);

        Waiting.instance.hide();

        this._current = Toast;
        Toast.start(data);
        this.add(Toast);
        Toast.visible = false;
        // egret.Tween.get(Toast).set({ visible: true, alpha: 0, y: -200 }).to({ alpha: 1, y: 0 }, 500, egret.Ease.cubicIn)
        //     .wait(time)
        //     .call(() => {
        //         this._parent.visible = false;
        //     })

        egret.Tween.get(Toast).set({ visible: true, anchorOffsetX: 375, anchorOffsetY: 585, x: 375, y: 585, scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 300, egret.Ease.cubicIn)
            .wait(time)
            .call(() => {
                this._parent.visible = false;
            })
        return Toast;
    }


    /**
     * 移除蒙层
     */
    removeMask() {
        if (this._mask) {
            egret.Tween.get(this._mask).to({ alpha: 0 }, 200).call(
                () => this._parent.removeChild(this._mask), this);
        }
    }

    /**
     * 立刻移除蒙层
     */
    removeMaskImmediately() {
        if (this._mask) {
            this._parent.removeChild(this._mask);
        }
    }


    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    /**
     * 动画后移除Panel
     * @param panel 
     */
    private remove(panel: Panel) {
        const tw = egret.Tween.get(panel);
        tw.to({ y: 1624 }, 400, egret.Ease.getBackIn(2))
            .call(() => {
                egret.Tween.removeAllTweens();
                this._parent.removeChild(panel);
                this._parent.visible = false;
                this._current = null;
                this.removeMask();
            }, this);
    }

    /**
     * 立即移除Panel
     * @param panel 
     */
    private removeImmediately(panel: Panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        this.removeMaskImmediately();
    }


    /**
     * 隐藏Panel
     * @param e 
     */
    private onPanelHide(e: egret.Event) {
        let panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.removeImmediately(panel);
    }

    private _toastClassMap: any;

    /**
     * 注册Panel
     * @param name Panel名字
     * @param definition 定义 
     */
    registerClass(name = ModuleTypes.TOAST, definition = Toast) {
        this._toastClassMap = this._toastClassMap || {};
        this._toastClassMap[name] = definition;
    }


    private _current: Panel;

    /**
     * 关闭当前 有动画
     */
    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }

    /**
     * 关闭当前 无动画
     */
    closeCurrentImmediately() {
        if (this._current)
            this.removeImmediately(this._current);
    }
}