import { ModuleTypes } from "../types/sceneTypes";
import Scene from "../views/Scene";
export default class SceneCtrl {
    private _parent: eui.UILayer;
    private _currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    change(type: ModuleTypes, data?) {
        if (this._currentScene) {
            this._currentScene.destroy();
            this._parent.removeChild(this._currentScene);
        }
        const cls = this._sceneClassMap[type];
        const scene: Scene = data ? new cls(data) : new cls();
        if (data) {
            scene.start(data);
        } else {
            scene.start();
        }

        this.addToStage(scene);
    }

    private addToStage(scene: Scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);

    }

    private _sceneClassMap: any;
    registerClass(name, definition) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = definition;
    }
}