import { GTime } from './../../libs/tc/util/GTime';
import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Msg from "../alert/Msg";
import Waiting from "../waiting/Waiting";
import GameConst from '../GameConst';
export default class PanelCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Sprite;
    static _instance: PanelCtrl;
    /**
     * 实例
     */
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    /**
     * 初始化
     * @param parent 赋值父级 
     */
    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    /**
     * 显示
     * @param type 类型
     * @param data 数据
     */
    show(type: ModuleTypes, data?, afterAni?: Function) {
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current)
        } else {

        }
        this.addMask();
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);

        Waiting.instance.hide();

        this._current = panel;
        panel.start(data);
        this.add(panel);
        panel.visible = false;
        // egret.Tween.get(panel).set({ visible: true, alpha: 0, y: -200 }).to({ alpha: 1, y: 0 }, 500, egret.Ease.cubicIn).call(() => {
        //     afterAni && afterAni(panel);
        // });
        egret.Tween.get(panel).set({ visible: true, anchorOffsetX: 375, anchorOffsetY: 500, x: 375, y: 500, scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 500, egret.Ease.cubicIn).call(() => {
            afterAni && afterAni();
        })
        return panel;
    }

    /**
     * 立即显示
     * @param type 类型
     * @param data 数据
     */
    showImmediately(type: ModuleTypes, data?, afterAni?: Function) {
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current)
        } else {

        }
        this.addMask();
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);

        Waiting.instance.hide();

        this._current = panel;
        panel.start(data);
        this.add(panel);
        afterAni && afterAni();

        return panel;
    }

    /**
     * 向上滑动显示
     * @param type 
     * @param targetY 
     * @param data 
     * @param afterAni 
     */
    slideUp(type: ModuleTypes, targetY: number = GameConst.stage.stageHeight * 2 / 5, data?, afterAni?: Function) {
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current)
        }

        this.addMask();
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);

        Waiting.instance.hide();

        this._current = panel;
        panel.y = 1800;
        panel.visible = true;
        this.add(panel);

        egret.Tween.get(panel).set({ visible: true, anchorOffsetX: 375, anchorOffsetY: 500, x: 375, y: 1800, scaleX: 1, scaleY: 1 }).to({ y: targetY }, 500).call(() => {
            afterAni && afterAni();
        })
    }


    /**
     * 加入黑色蒙层
     */
    addMask() {
        if (!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .7);
            this._mask.graphics.drawRect(0, 0, 750, 1624);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    }

    /**
     * 移除蒙层
     */
    removeMask() {
        if (this._mask) {
            egret.Tween.get(this._mask).to({ alpha: 0 }, 200).call(
                () => this._parent.removeChild(this._mask), this);
        }
    }

    /**
     * 立刻移除蒙层
     */
    removeMaskImmediately() {
        if (this._mask) {
            this._parent.removeChild(this._mask);
        }
    }


    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    /**
     * 动画后移除Panel
     * @param panel 
     */
    private remove(panel: Panel) {
        const tw = egret.Tween.get(panel);
        tw.to({ y: 1624 }, 400, egret.Ease.getBackIn(2))
            .call(() => {
                egret.Tween.removeAllTweens();
                this._parent.removeChild(panel);
                this._parent.visible = false;
                this._current = null;
                this.removeMask();
            }, this);
    }

    /**
     * 立即移除Panel
     * @param panel 
     */
    private removeImmediately(panel: Panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        this.removeMaskImmediately();
    }


    /**
     * 隐藏Panel
     * @param e 
     */
    private onPanelHide(e: egret.Event) {
        let panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.removeImmediately(panel);
    }

    private _panelClassMap: any;

    /**
     * 注册Panel
     * @param name Panel名字
     * @param definition 定义 
     */
    registerClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }


    private _current: Panel;

    /**
     * 关闭当前 有动画
     */
    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }

    /**
     * 关闭当前 无动画
     */
    closeCurrentImmediately() {
        if (this._current)
            this.removeImmediately(this._current);
    }
}