import { weidianNet } from './../NetConst';
import { ModuleTypes } from './../types/sceneTypes';
import Scene from "../views/Scene";
import SceneCtrl from "../ctrls/sceneCtrl";
import PanelCtrl from '../ctrls/panelCtrl';
import ToastCtrl from '../ctrls/toastCtrl';

export default class BeginScene extends Scene {
    public get skinKey() { return "Begin" }

    public dog: eui.Image;
    public openStoreBtn: eui.Button;
    public words0: eui.Image;
    public words1: eui.Image;
    public words2: eui.Image;

    constructor() {
        super();
        this.initBuired();
        this.initUI();
        this.initAni();

    }

    initBuired() {

    }

    initUI() {

    }

    async initAni() {
        this.dogAni();
        await this.words0Ani();
        this.hideWords0();
        await this.words1Ani();
        this.hideWords1();
        await this.words2Ani();
        this.hideWords2();
        this.showBtn();
    }

    dogAni() {
        egret.Tween.get(this.dog, { loop: true })
            .to({ scaleY: 0.98 }, 500)
            .to({ scaleY: 1 }, 500)
    }

    words0Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words0)
                .set({ alpha: 0, y: 80 })
                .to({ alpha: 1, y: 30 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords0() {
        egret.Tween.get(this.words0)
            .to({ alpha: 0, y: 15 }, 300)
    }

    words1Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words1)
                .set({ alpha: 0, y: 80 })
                .to({ alpha: 1, y: 30 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords1() {
        egret.Tween.get(this.words1)
            .to({ alpha: 0, y: 15 }, 300)
    }

    words2Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words2)
                .set({ alpha: 0, y: 80 })
                .to({ alpha: 1, y: 30 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords2() {
        egret.Tween.get(this.words2)
            .to({ alpha: 0, y: 15 }, 300)
    }

    showBtn() {
        egret.Tween.get(this.openStoreBtn)
            .to({ alpha: 1 }, 300)
            .call(() => {

                egret.Tween.get(this.openStoreBtn, { loop: true })
                    .set({ scaleX: 1, scaleY: 1 })
                    .to({ scaleX: 0.95, scaleY: 1.05 }, 160)
                    .to({ scaleX: 1, scaleY: 1 }, 160)
                    .to({ scaleX: 0.95, scaleY: 1.05 }, 160)
                    .to({ scaleX: 1, scaleY: 1 }, 160)
                    .wait(600)
            })
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.openStoreBtn, this.onTap_openStoreBtn)
    }

    onTap_openStoreBtn() {
        // 接口 第一次进
        weidianNet.openStore((s) => {
            if (!s) {
                ToastCtrl.instance.show("开店失败，请重试~")
                return
            }
            weidianNet.index((ss) => {
                if (!ss) {
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络开了小差，请稍后重试~", type: "reload" })
                    return
                }
                weidianNet.getShopsInfo(() => {
                    weidianNet.getFriendsInfo(() => {
                        SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE, true);
                    }, window['projectxId'])
                }, window["projectxId"])
            }, window['projectxId'])
        }, window["projectxId"])
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.openStoreBtn, this.onTap_openStoreBtn)
    }
}