import { PetsInfoData } from './../libs/tw/data/pets/PetsInfoData';

import { Buried } from './../libs/tw/util/Buried';
import { GDispatcher } from './../libs/tc/util/GDispatcher';
import { DataManager } from './../libs/tw/manager/DataManager';
import { ABNetManager } from './../libs/tc/manager/ABNetManager';
import { INetData } from './../libs/tc/interface/INetData';
import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import RulePanel from './rulePanel/RulePanel';
import Msg from "./alert/Msg";
import GameConst, { wait } from './GameConst';
import Waiting from './waiting/Waiting';
import NetConst from './NetConst';
import NoPrizePanel from './prize/NoPrizePanel';
import PrizePanel from './prize/PrizePanel';
import ToastCtrl from './ctrls/toastCtrl';
// import SVGACtrl from './ctrls/svgaCtrl';
import LoginPanel from './login/LoginPanel';
import GetCreditsPanel from './getCredits/GetCreditsPanel';
import SVGACtrl from './ctrls/svgaCtrl';
import MainScene from './mainScene/MainScene';
import WarningPanel from './warning/WarningPanel';
import NetModel from './NetModel';
import FirstSignPrizePanel from './sign/FirstSignPrizePanel';
import SignPrizePanel from './sign/SignPrizePanel';
import FullSignPrizePanel from './sign/FullSignPrizePanel';
import LoadingScene from './loadingScene/LoadingScene';
import BeginScene from './beginScene/BeginScene';
import GuideBuyPanel from './pop/GuideBuyPanel';
import TaskPanel from './pop/TaskPanel';
import GiftScene from './Gift/GiftScene';
import SharePanel from './pop/SharePanel';
import GuideSurePanel from './pop/GuideSurePanel';
import MinorScene from './minorScene/MinorScene';
import ShopScene from './shopScene/ShopScene';
import UpLevelPanel from './pop/UpLevelPanel';
import SignPanel from './pop/SignPanel';
import PumpedPanel from './pop/PumpedPanel';
import PayPanel from './pop/PayPanel';
import LeavePanel from './pop/LeavePanel';
import GuideNewPanel from './pop/GuideNewPanel';
import GiftSuccessPanel from './pop/GiftSuccessPanel';
import GiftListPanel from './pop/GiftListPanel';
import FoodReadyPanel from './pop/FoodReadyPanel';
import FoodGoPanel from './pop/FoodGoPanel';
import FoodEndPanel from './pop/FoodEndPanel';
import ConvertPanel from './pop/ConvertPanel';
import RevenuePanel from './pop/RevenuePanel';

class Main extends MainBase {

    protected registerModules() {

        // 注册Toast
        ToastCtrl.instance.registerClass();
        // 注册所有Panel
        PanelCtrl.instance.registerClass(ModuleTypes.LOGIN_PANEL, LoginPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GETCREDITS_PANEL, GetCreditsPanel)
        PanelCtrl.instance.registerClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FIRST_SIGN_PRIZE_PANEL, FirstSignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.DAILY_SIGN_PRIZE_PANEL, SignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FULL_SIGN_PRIZE_PANEL, FullSignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PRIZE_PANEL, PrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.NOPRIZE_PANEL, NoPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.WARNING_PANEL, WarningPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.DECORATION_PANEL, GuideBuyPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.TASK_PANEL, TaskPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.INVITE_PANEL, SharePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GUIDESURE_PANEL, GuideSurePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.CONVERT_PANEL, ConvertPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FOODEND_PANEL, FoodEndPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FOODGO_PANEL, FoodGoPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FOODREADY_PANEL, FoodReadyPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GIFTLIST_PANEL, GiftListPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GIFTSUCCESS_PANEL, GiftSuccessPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GUIDEBUY_PANEL, GuideBuyPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GUIDENEW_PANEL, GuideNewPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GUIDESURE_PANEL, GuideSurePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.LEAVE_PANEL, LeavePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PAY_PANEL, PayPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PUMPED_PANEL, PumpedPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.REVENUE_PANEL, RevenuePanel)
        PanelCtrl.instance.registerClass(ModuleTypes.SHARE_PANEL, SharePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.SIGN_PANEL, SignPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.TASK_PANEL, TaskPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.UPLEVEL_PANEL, UpLevelPanel)

        PanelCtrl.instance.registerClass(ModuleTypes.GUIDEBUY_PANEL, GuideBuyPanel);
        // 注册所有Scene
        SceneCtrl.instance.registerClass(ModuleTypes.LOADING_SCENE, LoadingScene);
        SceneCtrl.instance.registerClass(ModuleTypes.BEGIN_SCENE, BeginScene);
        SceneCtrl.instance.registerClass(ModuleTypes.MAIN_SCENE, MainScene);
        SceneCtrl.instance.registerClass(ModuleTypes.EXCHANGE_SCENE, GiftScene);
        SceneCtrl.instance.registerClass(ModuleTypes.MINOR_SCENE, MinorScene);
        SceneCtrl.instance.registerClass(ModuleTypes.SHOP_SCENE, ShopScene);
        SceneCtrl.instance.registerClass(ModuleTypes.GIFT_SCENE, GiftScene);
        // NetManager.ins.onNotSuccess = (msg) => {
        //     showAlertPanel(msg)
        // }
    }

    // 获取数据
    public updateCount: number = 0;
    protected async getData() {
        super.getData();
        //加载svga
        Promise.all([
            SVGACtrl.instance.load("waitressLv1", "//yun.duiba.com.cn/db_games/activity/weidian1.0/1569133654/resource/assets/mainScene/waitressLv1.svga"),
            SVGACtrl.instance.load("waitressLv2", "//yun.duiba.com.cn/db_games/activity/weidian1.0/1569133654/resource/assets/mainScene/waitressLv2.svga"),
            SVGACtrl.instance.load("waitressLv3", "//yun.duiba.com.cn/db_games/activity/weidian1.0/1569133654/resource/assets/mainScene/waitressLv3.svga"),
            SVGACtrl.instance.load("getfood", "//yun.duiba.com.cn/db_games/activity/weidian1.0/1569133654/resource/assets/wdpop/foodgo/get.svga")
        ])
        // let soundArr = ["numCountDown_mp3", "rightTips_mp3"]
        // preloadSound(soundArr);

    }



    // 设置派发事件
    protected GDispatchEvent() {
        GDispatcher.addEvent(ABNetManager.ERROR, (net: INetData, msg = '') => {
            const msgData = {
                net: net,
                msg: msg,
                // sureBtnTxt: TlLang.lang_011
            };
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData)
        }, this);
        // 监听当预加载资源加载完毕


        GDispatcher.addEvent('PreloadLoaded', () => {
            Waiting.instance.show()
            // SceneCtrl.instance.change(ModuleTypes.LOADING_SCENE);
            // this.createGameScene()
        }, this);
        GDispatcher.addEvent('LoadingLoaded', () => {
            Waiting.instance.hide()
            SceneCtrl.instance.change(ModuleTypes.LOADING_SCENE);
        }, this);
        // GDispatcher.addEvent('DelayLoaded', () => {

        //     Waiting.instance.hide()
        //     this.createGameScene()
        // }, this);
    }

    protected onResourceLoadComplete(event: RES.ResourceEvent): void {

        for (let i = 0; i < ResGroupNameArr.length; i++) {
            if (event.groupName == ResGroupNameArr[i]) {
                // debugger
                // this.loadBg("startBg.png");
                GDispatcher.dispatchEvent(`${ResGroupNameArr[i]}Loaded`);
                window[`is${ResGroupNameArr[i]}Loaded`] = true;
                if (i <= ResGroupNameArr.length - 2) {
                    this.trace(`${ResGroupNameArr[i]}组加载完成`);
                    RES.loadGroup(ResGroupNameArr[i + 1]);
                    this.trace(`开始加载${ResGroupNameArr[i + 1]}资源`);
                } else if (i == ResGroupNameArr.length - 1) {
                    this.trace(`${ResGroupNameArr[i]}组加载完成`);
                    GameConst.stage = this.stage;
                    setTimeout(() => {
                        console.log(GameConst.stage.width, GameConst.stage.height)
                    }, 100);
                    RES.removeEventListener(RES.ResourceEvent.GROUP_COMPLETE, this.onResourceLoadComplete, this);
                    RES.removeEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceLoadError, this);
                    RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
                }
            }
        }


    }

    // 创建游戏场景
    protected async createGameScene() {
        super.createGameScene();
        //获取UA信息
        let userAgent = navigator.userAgent.toLowerCase();
        console.log(userAgent);
        GameConst.stage = this.stage;
        setTimeout(() => {
            console.log(GameConst.stage.width, GameConst.stage.height)
        }, 100);

        Buried.init();
        // 端内发接口
        // await Promise.all([NetModel.getPetsInfo(), NetModel.getSignInfo(), NetModel.winners(2), NetModel.getPetsConfig()]);
        // console.log(DataManager.ins.getPetsInfoData, DataManager.ins.getData("getSignInfo"), DataManager.ins.getData("winners"));
        // console.log("change");

        // SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)

    }

    /**
     * 资源组加载出错
     */
    protected onResourceLoadError(event: RES.ResourceEvent): void {
        this.trace("preload组加载失败");
        //忽略加载失败的项目
        this.onResourceLoadComplete(event);
    }



}

export const ResGroupNameArr = ["Preload", "Loading", "Alert", "BeginScene", "Common", "MinorScene", "Convert", "MainScene1", "MainScene2", "MainScene3", "Food", "Gift", "GuideBuy", "GuideNew", "Leave", "Pay", "Pumped", "Revenue", "Share", "Sign", "Task", "UpLevel"]

window['Main'] = Main;
egret.ImageLoader.crossOrigin = "anonymous";
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context: any) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});